/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admission.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.admission.v1beta1.AdmissionResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AdmissionResponseFluent<A extends AdmissionResponseFluent<A>>
extends BaseFluent<A> {
    private Boolean allowed;
    private Map<String, String> auditAnnotations;
    private String patch;
    private String patchType;
    private Status status;
    private String uid;
    private List<String> warnings = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public AdmissionResponseFluent() {
    }

    public AdmissionResponseFluent(AdmissionResponse instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AdmissionResponse instance) {
        AdmissionResponse admissionResponse = instance = instance != null ? instance : new AdmissionResponse();
        if (instance != null) {
            this.withAllowed(instance.getAllowed());
            this.withAuditAnnotations(instance.getAuditAnnotations());
            this.withPatch(instance.getPatch());
            this.withPatchType(instance.getPatchType());
            this.withStatus(instance.getStatus());
            this.withUid(instance.getUid());
            this.withWarnings(instance.getWarnings());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getAllowed() {
        return this.allowed;
    }

    public A withAllowed(Boolean allowed) {
        this.allowed = allowed;
        return (A)((Object)this);
    }

    public boolean hasAllowed() {
        return this.allowed != null;
    }

    public A addToAuditAnnotations(String key, String value) {
        if (this.auditAnnotations == null && key != null && value != null) {
            this.auditAnnotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.auditAnnotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAuditAnnotations(Map<String, String> map) {
        if (this.auditAnnotations == null && map != null) {
            this.auditAnnotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.auditAnnotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAuditAnnotations(String key) {
        if (this.auditAnnotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.auditAnnotations != null) {
            this.auditAnnotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAuditAnnotations(Map<String, String> map) {
        if (this.auditAnnotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.auditAnnotations == null) continue;
                this.auditAnnotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAuditAnnotations() {
        return this.auditAnnotations;
    }

    public <K, V> A withAuditAnnotations(Map<String, String> auditAnnotations) {
        this.auditAnnotations = auditAnnotations == null ? null : new LinkedHashMap<String, String>(auditAnnotations);
        return (A)((Object)this);
    }

    public boolean hasAuditAnnotations() {
        return this.auditAnnotations != null;
    }

    public String getPatch() {
        return this.patch;
    }

    public A withPatch(String patch) {
        this.patch = patch;
        return (A)((Object)this);
    }

    public boolean hasPatch() {
        return this.patch != null;
    }

    public String getPatchType() {
        return this.patchType;
    }

    public A withPatchType(String patchType) {
        this.patchType = patchType;
        return (A)((Object)this);
    }

    public boolean hasPatchType() {
        return this.patchType != null;
    }

    public Status getStatus() {
        return this.status;
    }

    public A withStatus(Status status) {
        this.status = status;
        return (A)((Object)this);
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public String getUid() {
        return this.uid;
    }

    public A withUid(String uid) {
        this.uid = uid;
        return (A)((Object)this);
    }

    public boolean hasUid() {
        return this.uid != null;
    }

    public A addToWarnings(int index, String item) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.add(index, item);
        return (A)((Object)this);
    }

    public A setToWarnings(int index, String item) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.set(index, item);
        return (A)((Object)this);
    }

    public A addToWarnings(String ... items) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        for (String item : items) {
            this.warnings.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToWarnings(Collection<String> items) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        for (String item : items) {
            this.warnings.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromWarnings(String ... items) {
        if (this.warnings == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.warnings.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromWarnings(Collection<String> items) {
        if (this.warnings == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.warnings.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public String getWarning(int index) {
        return this.warnings.get(index);
    }

    public String getFirstWarning() {
        return this.warnings.get(0);
    }

    public String getLastWarning() {
        return this.warnings.get(this.warnings.size() - 1);
    }

    public String getMatchingWarning(Predicate<String> predicate) {
        for (String item : this.warnings) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingWarning(Predicate<String> predicate) {
        for (String item : this.warnings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withWarnings(List<String> warnings) {
        if (warnings != null) {
            this.warnings = new ArrayList<String>();
            for (String item : warnings) {
                this.addToWarnings(item);
            }
        } else {
            this.warnings = null;
        }
        return (A)((Object)this);
    }

    public A withWarnings(String ... warnings) {
        if (this.warnings != null) {
            this.warnings.clear();
            this._visitables.remove((Object)"warnings");
        }
        if (warnings != null) {
            for (String item : warnings) {
                this.addToWarnings(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasWarnings() {
        return this.warnings != null && !this.warnings.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdmissionResponseFluent that = (AdmissionResponseFluent)((Object)o);
        if (!Objects.equals(this.allowed, that.allowed)) {
            return false;
        }
        if (!Objects.equals(this.auditAnnotations, that.auditAnnotations)) {
            return false;
        }
        if (!Objects.equals(this.patch, that.patch)) {
            return false;
        }
        if (!Objects.equals(this.patchType, that.patchType)) {
            return false;
        }
        if (!Objects.equals(this.status, that.status)) {
            return false;
        }
        if (!Objects.equals(this.uid, that.uid)) {
            return false;
        }
        if (!Objects.equals(this.warnings, that.warnings)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.allowed, this.auditAnnotations, this.patch, this.patchType, this.status, this.uid, this.warnings, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowed != null) {
            sb.append("allowed:");
            sb.append(this.allowed + ",");
        }
        if (this.auditAnnotations != null && !this.auditAnnotations.isEmpty()) {
            sb.append("auditAnnotations:");
            sb.append(String.valueOf(this.auditAnnotations) + ",");
        }
        if (this.patch != null) {
            sb.append("patch:");
            sb.append(this.patch + ",");
        }
        if (this.patchType != null) {
            sb.append("patchType:");
            sb.append(this.patchType + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(String.valueOf(this.status) + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid + ",");
        }
        if (this.warnings != null && !this.warnings.isEmpty()) {
            sb.append("warnings:");
            sb.append(String.valueOf(this.warnings) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAllowed() {
        return this.withAllowed(true);
    }
}

