/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.http;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.net.URL;
import java.util.Set;
import org.apache.druid.indexing.overlord.DruidOverlord;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.http.RedirectInfo;

public class OverlordRedirectInfo
implements RedirectInfo {
    private static final Set<String> LOCAL_PATHS = ImmutableSet.of((Object)"/druid/indexer/v1/leader", (Object)"/druid/indexer/v1/isLeader");
    private final DruidOverlord overlord;

    @Inject
    public OverlordRedirectInfo(DruidOverlord overlord) {
        this.overlord = overlord;
    }

    public boolean doLocal(String requestURI) {
        return requestURI != null && LOCAL_PATHS.contains(requestURI) || this.overlord.isLeader();
    }

    public URL getRedirectURL(String queryString, String requestURI) {
        try {
            Optional<String> redirectLocation = this.overlord.getRedirectLocation();
            if (!redirectLocation.isPresent()) {
                return null;
            }
            String location = StringUtils.format((String)"%s%s", (Object[])new Object[]{redirectLocation.get(), requestURI});
            if (queryString != null) {
                location = StringUtils.format((String)"%s?%s", (Object[])new Object[]{location, queryString});
            }
            return new URL(location);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

