/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.input;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.transform.Transform;
import org.apache.druid.segment.transform.TransformSpec;

public class InputRowSchemas {
    private InputRowSchemas() {
    }

    public static InputRowSchema fromDataSchema(DataSchema dataSchema) {
        return new InputRowSchema(dataSchema.getTimestampSpec(), dataSchema.getDimensionsSpec(), InputRowSchemas.createColumnsFilter(dataSchema.getTimestampSpec(), dataSchema.getDimensionsSpec(), dataSchema.getTransformSpec(), dataSchema.getAggregators()), Arrays.stream(dataSchema.getAggregators()).map(AggregatorFactory::getName).collect(Collectors.toSet()));
    }

    public static ColumnsFilter createColumnsFilter(TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, TransformSpec transformSpec, AggregatorFactory[] aggregators) {
        Set transformOutputNames = transformSpec.getTransforms().stream().map(Transform::getName).collect(Collectors.toSet());
        if (dimensionsSpec.hasFixedDimensions()) {
            HashSet<String> inclusions = new HashSet<String>();
            inclusions.add(timestampSpec.getTimestampColumn());
            inclusions.addAll(transformSpec.getRequiredColumns());
            for (String column : dimensionsSpec.getDimensionNames()) {
                if (transformOutputNames.contains(column)) continue;
                inclusions.add(column);
            }
            for (AggregatorFactory aggregator : aggregators) {
                for (String column : aggregator.requiredFields()) {
                    if (transformOutputNames.contains(column)) continue;
                    inclusions.add(column);
                }
            }
            return ColumnsFilter.inclusionBased(inclusions);
        }
        HashSet exclusions = new HashSet(dimensionsSpec.getDimensionExclusions());
        exclusions.remove(timestampSpec.getTimestampColumn());
        exclusions.removeAll(transformSpec.getRequiredColumns());
        for (AggregatorFactory aggregator : aggregators) {
            for (String column : aggregator.requiredFields()) {
                if (transformOutputNames.contains(column)) continue;
                exclusions.remove(column);
            }
        }
        return ColumnsFilter.exclusionBased(exclusions);
    }
}

