/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.compact;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.indexing.compact.CompactionJobTemplate;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class CompactionRule {
    private final Period period;
    private final CompactionJobTemplate template;

    @JsonCreator
    public CompactionRule(@JsonProperty(value="period") Period period, @JsonProperty(value="template") CompactionJobTemplate template) {
        this.period = period;
        this.template = template;
    }

    @JsonProperty
    public CompactionJobTemplate getTemplate() {
        return this.template;
    }

    @JsonProperty
    public Period getPeriod() {
        return this.period;
    }

    public DateTime computeStartTime(DateTime referenceTime, CompactionRule beforeRule) {
        Granularity granularity = this.template.getSegmentGranularity();
        Granularity beforeGranularity = beforeRule.template.getSegmentGranularity();
        DateTime calculatedStartTime = referenceTime.minus((ReadablePeriod)this.period);
        if (granularity == null || beforeGranularity == null) {
            return calculatedStartTime;
        }
        DateTime beforeRuleEffectiveEnd = beforeGranularity.bucketStart(calculatedStartTime);
        DateTime possibleStartTime = granularity.bucketStart(beforeRuleEffectiveEnd);
        return possibleStartTime.isBefore((ReadableInstant)beforeRuleEffectiveEnd) ? granularity.increment(possibleStartTime) : possibleStartTime;
    }
}

