/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.report.KillTaskReport;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.RetrieveUnusedSegmentsAction;
import org.apache.druid.indexing.common.actions.RetrieveUpgradedFromSegmentIdsAction;
import org.apache.druid.indexing.common.actions.RetrieveUpgradedToSegmentIdsAction;
import org.apache.druid.indexing.common.actions.RetrieveUsedSegmentsAction;
import org.apache.druid.indexing.common.actions.SegmentNukeAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskLocks;
import org.apache.druid.indexing.common.actions.TimeChunkLockTryAcquireAction;
import org.apache.druid.indexing.common.actions.UpgradedToSegmentsResponse;
import org.apache.druid.indexing.common.task.AbstractFixedIntervalTask;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordination.BroadcastDatasourceLoadingSpec;
import org.apache.druid.server.lookup.cache.LookupLoadingSpec;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class KillUnusedSegmentsTask
extends AbstractFixedIntervalTask {
    public static final String TYPE = "kill";
    private static final Logger LOG = new Logger(KillUnusedSegmentsTask.class);
    private static final int DEFAULT_SEGMENT_NUKE_BATCH_SIZE = 100;
    @Nullable
    private final List<String> versions;
    private final int batchSize;
    @Nullable
    private final Integer limit;
    @Nullable
    private final DateTime maxUsedStatusLastUpdatedTime;

    @JsonCreator
    public KillUnusedSegmentsTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="versions") @Nullable List<String> versions, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="batchSize") Integer batchSize, @JsonProperty(value="limit") @Nullable Integer limit, @JsonProperty(value="maxUsedStatusLastUpdatedTime") @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        super(KillUnusedSegmentsTask.getOrMakeId(id, TYPE, dataSource, interval), dataSource, interval, context);
        int n = this.batchSize = batchSize != null ? batchSize : 100;
        if (this.batchSize <= 0) {
            throw InvalidInput.exception((String)"batchSize[%d] must be a positive integer.", (Object[])new Object[]{batchSize});
        }
        if (limit != null && limit <= 0) {
            throw InvalidInput.exception((String)"limit[%d] must be a positive integer.", (Object[])new Object[]{limit});
        }
        this.versions = versions;
        this.limit = limit;
        this.maxUsedStatusLastUpdatedTime = maxUsedStatusLastUpdatedTime;
    }

    @Nullable
    @JsonProperty
    public List<String> getVersions() {
        return this.versions;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int getBatchSize() {
        return this.batchSize;
    }

    @Nullable
    @JsonProperty
    public Integer getLimit() {
        return this.limit;
    }

    @Nullable
    @JsonProperty
    public DateTime getMaxUsedStatusLastUpdatedTime() {
        return this.maxUsedStatusLastUpdatedTime;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return ImmutableSet.of();
    }

    @Override
    public TaskStatus runTask(TaskToolbox toolbox) throws Exception {
        int numSegmentsKilled = 0;
        int numBatchesProcessed = 0;
        int nextBatchSize = this.computeNextBatchSize(numSegmentsKilled);
        Integer numTotalBatches = this.getNumTotalBatches();
        this.logInfo("Starting kill for datasource[%s] in interval[%s] and versions[%s] with batchSize[%d], up to limit[%d] segments before maxUsedStatusLastUpdatedTime[%s] will be deleted%s", this.getDataSource(), this.getInterval(), this.getVersions(), this.batchSize, this.limit, this.maxUsedStatusLastUpdatedTime, numTotalBatches != null ? StringUtils.format((String)" in [%d] batches.", (Object[])new Object[]{numTotalBatches}) : ".");
        TaskActionClient taskActionClient = toolbox.getTaskActionClient();
        RetrieveUsedSegmentsAction retrieveUsedSegmentsAction = new RetrieveUsedSegmentsAction(this.getDataSource(), (Collection<Interval>)ImmutableList.of((Object)this.getInterval()), Segments.INCLUDING_OVERSHADOWED);
        Set<Map<String, Object>> usedSegmentLoadSpecs = taskActionClient.submit(retrieveUsedSegmentsAction).stream().map(DataSegment::getLoadSpec).collect(Collectors.toSet());
        while (nextBatchSize > 0) {
            List<DataSegment> unusedSegments = this.fetchNextBatchOfUnusedSegments(toolbox, nextBatchSize);
            NavigableMap<DateTime, List<TaskLock>> taskLockMap = this.getNonRevokedTaskLockMap(toolbox.getTaskActionClient());
            if (!TaskLocks.isLockCoversSegments(taskLockMap, unusedSegments)) {
                throw new ISE("Locks[%s] for task[%s] can't cover segments[%s]", new Object[]{taskLockMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()), this.getId(), unusedSegments});
            }
            Set<String> segmentIds = unusedSegments.stream().map(DataSegment::getId).map(SegmentId::toString).collect(Collectors.toSet());
            HashMap<String, String> upgradedFromSegmentIds = new HashMap<String, String>();
            try {
                upgradedFromSegmentIds.putAll(taskActionClient.submit(new RetrieveUpgradedFromSegmentIdsAction(this.getDataSource(), segmentIds)).getUpgradedFromSegmentIds());
            }
            catch (Exception e) {
                LOG.warn((Throwable)e, "Could not retrieve parent segment ids using task action[retrieveUpgradedFromSegmentIds]. Overlord may be on an older version.", new Object[0]);
            }
            taskActionClient.submit(new SegmentNukeAction(new HashSet<DataSegment>(unusedSegments)));
            this.emitMetric(toolbox.getEmitter(), "segment/killed/metadataStore/count", unusedSegments.size());
            List<DataSegment> segmentsToBeKilled = this.getKillableSegments(unusedSegments, upgradedFromSegmentIds, usedSegmentLoadSpecs, taskActionClient);
            HashSet<DataSegment> segmentsNotKilled = new HashSet<DataSegment>(unusedSegments);
            segmentsToBeKilled.forEach(segmentsNotKilled::remove);
            if (!segmentsNotKilled.isEmpty()) {
                LOG.warn("Skipping kill of [%d] segments from deep storage as their load specs are used by other segments.", new Object[]{segmentsNotKilled.size()});
            }
            toolbox.getDataSegmentKiller().kill(segmentsToBeKilled);
            this.emitMetric(toolbox.getEmitter(), "segment/killed/deepStorage/count", segmentsToBeKilled.size());
            this.logInfo("Processed [%d] batches for kill task[%s].", ++numBatchesProcessed, this.getId());
            nextBatchSize = this.computeNextBatchSize(numSegmentsKilled += segmentsToBeKilled.size());
            if (!unusedSegments.isEmpty() && (null == numTotalBatches || numBatchesProcessed < numTotalBatches)) continue;
        }
        String taskId = this.getId();
        this.logInfo("Finished kill task[%s] for dataSource[%s] and interval[%s]. Deleted total [%d] unused segments in [%d] batches.", taskId, this.getDataSource(), this.getInterval(), numSegmentsKilled, numBatchesProcessed);
        KillTaskReport.Stats stats = new KillTaskReport.Stats(numSegmentsKilled, numBatchesProcessed);
        toolbox.getTaskReportFileWriter().write(taskId, TaskReport.buildTaskReports((TaskReport[])new TaskReport[]{new KillTaskReport(taskId, stats)}));
        return TaskStatus.success((String)taskId);
    }

    @JsonIgnore
    @Nullable
    protected Integer getNumTotalBatches() {
        return null != this.limit ? Integer.valueOf((int)Math.ceil((double)this.limit.intValue() / (double)this.batchSize)) : null;
    }

    @JsonIgnore
    @VisibleForTesting
    int computeNextBatchSize(int numSegmentsKilled) {
        return null != this.limit ? Math.min(this.limit - numSegmentsKilled, this.batchSize) : this.batchSize;
    }

    protected List<DataSegment> fetchNextBatchOfUnusedSegments(TaskToolbox toolbox, int nextBatchSize) throws IOException {
        return toolbox.getTaskActionClient().submit(new RetrieveUnusedSegmentsAction(this.getDataSource(), this.getInterval(), this.getVersions(), nextBatchSize, this.maxUsedStatusLastUpdatedTime));
    }

    protected void logInfo(String message, Object ... args) {
        LOG.info(message, args);
    }

    private NavigableMap<DateTime, List<TaskLock>> getNonRevokedTaskLockMap(TaskActionClient client) throws IOException {
        TreeMap<DateTime, List<TaskLock>> taskLockMap = new TreeMap<DateTime, List<TaskLock>>();
        KillUnusedSegmentsTask.getTaskLocks(client).forEach(taskLock -> {
            if (!taskLock.isRevoked()) {
                taskLockMap.computeIfAbsent(taskLock.getInterval().getStart(), k -> new ArrayList()).add(taskLock);
            }
        });
        return taskLockMap;
    }

    private List<DataSegment> getKillableSegments(List<DataSegment> unusedSegments, Map<String, String> upgradedFromSegmentIds, Set<Map<String, Object>> usedSegmentLoadSpecs, TaskActionClient taskActionClient) {
        HashMap<String, Set> parentIdToUnusedSegments = new HashMap<String, Set>();
        for (DataSegment segment2 : unusedSegments) {
            String segmentId = segment2.getId().toString();
            parentIdToUnusedSegments.computeIfAbsent(upgradedFromSegmentIds.getOrDefault(segmentId, segmentId), k -> new HashSet()).add(segment2);
        }
        try {
            UpgradedToSegmentsResponse response = taskActionClient.submit(new RetrieveUpgradedToSegmentIdsAction(this.getDataSource(), parentIdToUnusedSegments.keySet()));
            if (response != null && response.getUpgradedToSegmentIds() != null) {
                response.getUpgradedToSegmentIds().forEach((parent, children) -> {
                    if (!CollectionUtils.isNullOrEmpty((Collection)children)) {
                        LOG.info("Skipping kill of segments[%s] as its load spec is also used by segment IDs[%s].", new Object[]{parentIdToUnusedSegments.get(parent), children});
                        parentIdToUnusedSegments.remove(parent);
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "Could not retrieve referenced ids using task action[retrieveUpgradedToSegmentIds]. Overlord may be on an older version.", new Object[0]);
        }
        return parentIdToUnusedSegments.values().stream().flatMap(Collection::stream).filter(segment -> !this.isSegmentLoadSpecPresentIn((DataSegment)segment, usedSegmentLoadSpecs)).collect(Collectors.toList());
    }

    private boolean isSegmentLoadSpecPresentIn(DataSegment segment, Set<Map<String, Object>> usedSegmentLoadSpecs) {
        boolean isPresent = usedSegmentLoadSpecs.contains(segment.getLoadSpec());
        if (isPresent) {
            LOG.info("Skipping kill of segment[%s] as its load spec is also used by other segments.", new Object[]{segment});
        }
        return isPresent;
    }

    @Override
    public LookupLoadingSpec getLookupLoadingSpec() {
        return LookupLoadingSpec.NONE;
    }

    @Override
    public BroadcastDatasourceLoadingSpec getBroadcastDatasourceLoadingSpec() {
        return BroadcastDatasourceLoadingSpec.NONE;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        boolean useConcurrentLocks = Boolean.TRUE.equals(this.getContextValue("useConcurrentLocks", false));
        TaskLockType actualLockType = this.determineLockType(useConcurrentLocks);
        TaskLock lock = taskActionClient.submit(new TimeChunkLockTryAcquireAction(actualLockType, this.getInterval()));
        if (lock == null) {
            return false;
        }
        lock.assertNotRevoked();
        return true;
    }

    private TaskLockType determineLockType(boolean useConcurrentLocks) {
        TaskLockType actualLockType = useConcurrentLocks ? TaskLockType.REPLACE : this.getContextValue("taskLockType", TaskLockType.EXCLUSIVE);
        return actualLockType;
    }
}

