/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.timeline.partition.BuildingShardSpec;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartitionChunk;

public class BuildingNumberedShardSpec
implements BuildingShardSpec<NumberedShardSpec> {
    private final int partitionId;

    @JsonCreator
    public BuildingNumberedShardSpec(@JsonProperty(value="partitionId") int partitionId) {
        Preconditions.checkArgument((partitionId >= 0 ? 1 : 0) != 0, (Object)"partitionId >= 0");
        this.partitionId = partitionId;
    }

    @Override
    public int getBucketId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NumberedShardSpec convert(int numTotalPartitions) {
        return new NumberedShardSpec(this.partitionId, numTotalPartitions);
    }

    @Override
    public <T> PartitionChunk<T> createChunk(T obj) {
        return new NumberedPartitionChunk<T>(this.partitionId, 0, obj);
    }

    @Override
    @JsonProperty(value="partitionId")
    public int getPartitionNum() {
        return this.partitionId;
    }

    @Override
    public String getType() {
        return "building_numbered";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildingNumberedShardSpec shardSpec = (BuildingNumberedShardSpec)o;
        return this.partitionId == shardSpec.partitionId;
    }

    public int hashCode() {
        return Objects.hash(this.partitionId);
    }

    public String toString() {
        return "BuildingNumberedShardSpec{partitionId=" + this.partitionId + "}";
    }
}

