/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.data.CompressedVSizeColumnarIntsSerializer;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.FixedIndexedIntWriter;
import org.apache.druid.segment.data.GenericIndexedWriter;
import org.apache.druid.segment.data.SingleValueColumnarIntsSerializer;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.nested.DictionaryIdLookup;
import org.apache.druid.segment.nested.NestedCommonFormatColumnFormatSpec;
import org.apache.druid.segment.nested.NestedCommonFormatColumnSerializer;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public abstract class ScalarNestedCommonFormatColumnSerializer<T>
extends NestedCommonFormatColumnSerializer {
    protected static final Logger log = new Logger(ScalarNestedCommonFormatColumnSerializer.class);
    protected final String name;
    protected final SegmentWriteOutMedium segmentWriteOutMedium;
    protected final NestedCommonFormatColumnFormatSpec columnFormatSpec;
    protected final Closer closer;
    protected DictionaryIdLookup dictionaryIdLookup;
    protected DictionaryWriter<T> dictionaryWriter;
    protected boolean closedForWrite = false;
    protected boolean dictionarySerialized = false;
    protected FixedIndexedIntWriter intermediateValueWriter;
    protected ByteBuffer columnNameBytes = null;
    protected boolean hasNulls;
    protected boolean writeDictionary = true;

    public ScalarNestedCommonFormatColumnSerializer(String name, NestedCommonFormatColumnFormatSpec columnFormatSpec, SegmentWriteOutMedium segmentWriteOutMedium, Closer closer) {
        this.name = name;
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.columnFormatSpec = columnFormatSpec;
        this.closer = closer;
    }

    protected abstract int processValue(@Nullable Object var1) throws IOException;

    protected abstract void openValueColumnSerializer() throws IOException;

    protected abstract void writeValueColumn(SegmentFileBuilder var1) throws IOException;

    protected abstract void writeDictionaryFile(SegmentFileBuilder var1) throws IOException;

    public abstract int getCardinality();

    @Override
    public String getColumnName() {
        return this.name;
    }

    @Override
    public DictionaryIdLookup getDictionaryIdLookup() {
        return this.dictionaryIdLookup;
    }

    @Override
    public void setDictionaryIdLookup(DictionaryIdLookup dictionaryIdLookup) {
        this.dictionaryIdLookup = dictionaryIdLookup;
        this.writeDictionary = false;
        this.dictionarySerialized = true;
    }

    @Override
    public boolean hasNulls() {
        return this.hasNulls;
    }

    @Override
    public void open() throws IOException {
        if (!this.dictionarySerialized) {
            throw new IllegalStateException("Dictionary not serialized, cannot open value serializer");
        }
        this.intermediateValueWriter = new FixedIndexedIntWriter(this.segmentWriteOutMedium, false);
        this.intermediateValueWriter.open();
        this.openValueColumnSerializer();
    }

    @Override
    public void serialize(ColumnValueSelector<? extends StructuredData> selector) throws IOException {
        if (!this.dictionarySerialized) {
            throw new ISE("Must serialize value dictionaries before serializing values for column [%s]", this.name);
        }
        Object value = StructuredData.unwrap(selector.getObject());
        int dictId = this.processValue(value);
        this.intermediateValueWriter.write(dictId);
        this.hasNulls = this.hasNulls || dictId == 0;
    }

    private void closeForWrite() {
        if (!this.closedForWrite) {
            this.columnNameBytes = this.computeFilenameBytes();
            this.closedForWrite = true;
        }
    }

    @Override
    public long getSerializedSize() {
        this.closeForWrite();
        long size = 1 + this.columnNameBytes.capacity();
        return size;
    }

    @Override
    public void writeTo(WritableByteChannel channel, SegmentFileBuilder fileBuilder) throws IOException {
        Preconditions.checkState((boolean)this.closedForWrite, (Object)"Not closed yet!");
        if (this.writeDictionary) {
            Preconditions.checkArgument((boolean)this.dictionaryWriter.isSorted(), (Object)"Dictionary not sorted?!?");
        }
        String filenameBase = StringUtils.format("%s.forward_dim", this.name);
        CompressionStrategy compression = this.columnFormatSpec.getDictionaryEncodedColumnCompression();
        CompressionStrategy compressionToUse = compression != CompressionStrategy.UNCOMPRESSED && compression != CompressionStrategy.NONE ? compression : CompressionStrategy.LZ4;
        CompressedVSizeColumnarIntsSerializer encodedValueSerializer = CompressedVSizeColumnarIntsSerializer.create(this.name, this.segmentWriteOutMedium, filenameBase, this.getCardinality(), compressionToUse, this.segmentWriteOutMedium.getCloser());
        encodedValueSerializer.open();
        GenericIndexedWriter<ImmutableBitmap> bitmapIndexWriter = new GenericIndexedWriter<ImmutableBitmap>(this.segmentWriteOutMedium, this.name, this.columnFormatSpec.getBitmapEncoding().getObjectStrategy());
        bitmapIndexWriter.open();
        bitmapIndexWriter.setObjectsNotSorted();
        MutableBitmap[] bitmaps = new MutableBitmap[this.getCardinality()];
        IntIterator rows = this.intermediateValueWriter.getIterator();
        int rowCount = 0;
        while (rows.hasNext()) {
            int dictId = rows.nextInt();
            ((SingleValueColumnarIntsSerializer)encodedValueSerializer).addValue(dictId);
            MutableBitmap b = bitmaps[dictId];
            if (b == null) {
                bitmaps[dictId] = b = this.columnFormatSpec.getBitmapEncoding().getBitmapFactory().makeEmptyMutableBitmap();
            }
            b.add(rowCount++);
        }
        for (int i = 0; i < bitmaps.length; ++i) {
            MutableBitmap bitmap = bitmaps[i];
            if (bitmap == null) {
                bitmapIndexWriter.write(null);
            } else {
                bitmapIndexWriter.write(this.columnFormatSpec.getBitmapEncoding().getBitmapFactory().makeImmutableBitmap(bitmap));
            }
            bitmaps[i] = null;
        }
        ScalarNestedCommonFormatColumnSerializer.writeV0Header(channel, this.columnNameBytes);
        if (this.writeDictionary) {
            this.writeDictionaryFile(fileBuilder);
        }
        this.writeInternal(fileBuilder, encodedValueSerializer, "__encodedColumn");
        this.writeValueColumn(fileBuilder);
        this.writeInternal(fileBuilder, bitmapIndexWriter, "__valueIndexes");
        log.info("Column [%s] serialized successfully.", this.name);
    }
}

