/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.data.input.Rows;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowIdSupplier;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.RangeIndexedInts;
import org.apache.druid.segment.nested.StructuredData;

public class RowBasedColumnSelectorFactory<T>
implements ColumnSelectorFactory {
    private final Supplier<T> rowSupplier;
    @Nullable
    private final RowIdSupplier rowIdSupplier;
    private final RowAdapter<T> adapter;
    private final ColumnInspector columnInspector;
    private final boolean throwParseExceptions;
    private final boolean useStringValueOfNullInLists;

    public RowBasedColumnSelectorFactory(Supplier<T> rowSupplier, @Nullable RowIdSupplier rowIdSupplier, RowAdapter<T> adapter, ColumnInspector columnInspector, boolean throwParseExceptions, boolean useStringValueOfNullInLists) {
        this.rowSupplier = rowSupplier;
        this.rowIdSupplier = rowIdSupplier;
        this.adapter = adapter;
        this.columnInspector = (ColumnInspector)Preconditions.checkNotNull((Object)columnInspector, (Object)"columnInspector must be nonnull");
        this.throwParseExceptions = throwParseExceptions;
        this.useStringValueOfNullInLists = useStringValueOfNullInLists;
    }

    public static <RowType> RowBasedColumnSelectorFactory<RowType> create(RowAdapter<RowType> adapter, Supplier<RowType> supplier, ColumnInspector columnInspector, boolean throwParseExceptions, boolean useStringValueOfNullInLists) {
        return new RowBasedColumnSelectorFactory<RowType>(supplier, null, adapter, columnInspector, throwParseExceptions, useStringValueOfNullInLists);
    }

    @Nullable
    static ColumnCapabilities getColumnCapabilities(ColumnInspector columnInspector, String columnName) {
        if ("__time".equals(columnName)) {
            return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities(ColumnType.LONG);
        }
        ColumnCapabilities inspectedCapabilities = columnInspector.getColumnCapabilities(columnName);
        if (inspectedCapabilities != null) {
            if (inspectedCapabilities.isNumeric()) {
                return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities(inspectedCapabilities);
            }
            if (inspectedCapabilities.isArray()) {
                return ColumnCapabilitiesImpl.createSimpleArrayColumnCapabilities(inspectedCapabilities);
            }
            ColumnCapabilitiesImpl retVal = new ColumnCapabilitiesImpl().setType(inspectedCapabilities).setDictionaryValuesUnique(false).setDictionaryValuesSorted(false);
            if (inspectedCapabilities.hasMultipleValues().isFalse()) {
                retVal.setHasMultipleValues(false);
            }
            return retVal;
        }
        return null;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(dimensionSpec));
    }

    private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
        String dimension = dimensionSpec.getDimension();
        final ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
        if ("__time".equals(dimensionSpec.getDimension())) {
            if (extractionFn == null) {
                throw new UnsupportedOperationException("time dimension must provide an extraction function");
            }
            final ToLongFunction<T> timestampFunction = this.adapter.timestampFunction();
            return new BaseSingleValueDimensionSelector(){
                private long currentId = -1L;
                private String currentValue;

                @Override
                protected String getValue() {
                    this.updateCurrentValue();
                    return this.currentValue;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("row", RowBasedColumnSelectorFactory.this.rowSupplier);
                    inspector.visit("extractionFn", extractionFn);
                }

                private void updateCurrentValue() {
                    if (RowBasedColumnSelectorFactory.this.rowIdSupplier == null || RowBasedColumnSelectorFactory.this.rowIdSupplier.getRowId() != this.currentId) {
                        this.currentValue = extractionFn.apply(timestampFunction.applyAsLong(RowBasedColumnSelectorFactory.this.rowSupplier.get()));
                        if (RowBasedColumnSelectorFactory.this.rowIdSupplier != null) {
                            this.currentId = RowBasedColumnSelectorFactory.this.rowIdSupplier.getRowId();
                        }
                    }
                }
            };
        }
        final Function<T, Object> dimFunction = this.adapter.columnFunction(dimension);
        return new DimensionSelector(){
            private long currentId = -1L;
            private List<String> dimensionValues;
            private final RangeIndexedInts indexedInts = new RangeIndexedInts();

            @Override
            public IndexedInts getRow() {
                this.updateCurrentValues();
                this.indexedInts.setSize(this.dimensionValues.size());
                return this.indexedInts;
            }

            @Override
            public ValueMatcher makeValueMatcher(final @Nullable String value) {
                return new ValueMatcher(){

                    @Override
                    public boolean matches(boolean includeUnknown) {
                        this.updateCurrentValues();
                        if (dimensionValues.isEmpty()) {
                            return includeUnknown || value == null;
                        }
                        for (String dimensionValue : dimensionValues) {
                            if ((!includeUnknown || dimensionValue != null) && !Objects.equals(dimensionValue, value)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("row", RowBasedColumnSelectorFactory.this.rowSupplier);
                        inspector.visit("extractionFn", extractionFn);
                    }
                };
            }

            @Override
            public ValueMatcher makeValueMatcher(final DruidPredicateFactory predicateFactory) {
                final DruidObjectPredicate<String> predicate = predicateFactory.makeStringPredicate();
                return new ValueMatcher(){

                    @Override
                    public boolean matches(boolean includeUnknown) {
                        this.updateCurrentValues();
                        if (dimensionValues.isEmpty()) {
                            return predicate.apply(null).matches(includeUnknown);
                        }
                        for (String dimensionValue : dimensionValues) {
                            if (!predicate.apply(dimensionValue).matches(includeUnknown)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("row", RowBasedColumnSelectorFactory.this.rowSupplier);
                        inspector.visit("predicate", predicateFactory);
                        inspector.visit("extractionFn", extractionFn);
                    }
                };
            }

            @Override
            public int getValueCardinality() {
                return -1;
            }

            @Override
            public String lookupName(int id) {
                this.updateCurrentValues();
                return this.dimensionValues.get(id);
            }

            @Override
            public boolean nameLookupPossibleInAdvance() {
                return false;
            }

            @Override
            @Nullable
            public IdLookup idLookup() {
                return null;
            }

            @Override
            @Nullable
            public Object getObject() {
                this.updateCurrentValues();
                if (this.dimensionValues.size() == 1) {
                    return this.dimensionValues.get(0);
                }
                return this.dimensionValues;
            }

            @Override
            public Class classOfObject() {
                return Object.class;
            }

            @Override
            public boolean isNull() {
                this.updateCurrentValues();
                return DimensionHandlerUtils.isNumericNull(this.getObject());
            }

            @Override
            public float getFloat() {
                this.updateCurrentValues();
                return (float)this.getDouble();
            }

            @Override
            public double getDouble() {
                this.updateCurrentValues();
                String str = (String)Iterables.getOnlyElement(this.dimensionValues);
                return Doubles.tryParse((String)str);
            }

            @Override
            public long getLong() {
                this.updateCurrentValues();
                String str = (String)Iterables.getOnlyElement(this.dimensionValues);
                Long n = GuavaUtils.tryParseLong(str);
                if (n != null) {
                    return n;
                }
                return (long)this.getDouble();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("row", RowBasedColumnSelectorFactory.this.rowSupplier);
                inspector.visit("extractionFn", extractionFn);
            }

            private void updateCurrentValues() {
                if (RowBasedColumnSelectorFactory.this.rowIdSupplier == null || RowBasedColumnSelectorFactory.this.rowIdSupplier.getRowId() != this.currentId) {
                    try {
                        Object rawValue = dimFunction.apply(RowBasedColumnSelectorFactory.this.rowSupplier.get());
                        if (rawValue == null || rawValue instanceof String) {
                            String s = (String)rawValue;
                            this.dimensionValues = extractionFn == null ? Collections.singletonList(s) : Collections.singletonList(extractionFn.apply(s));
                        } else if (rawValue instanceof List) {
                            ArrayList<String> values = new ArrayList<String>(((List)rawValue).size());
                            for (Object item : (List)rawValue) {
                                String itemString;
                                if (RowBasedColumnSelectorFactory.this.useStringValueOfNullInLists) {
                                    itemString = String.valueOf(item);
                                } else {
                                    String string = itemString = item == null ? null : String.valueOf(item);
                                }
                                if (extractionFn == null) {
                                    values.add(itemString);
                                    continue;
                                }
                                values.add(extractionFn.apply(itemString));
                            }
                            this.dimensionValues = values;
                        } else {
                            List<String> nonExtractedValues = Rows.objectToStrings(rawValue);
                            this.dimensionValues = new ArrayList<String>(nonExtractedValues.size());
                            for (String value : nonExtractedValues) {
                                if (extractionFn == null) {
                                    this.dimensionValues.add(value);
                                    continue;
                                }
                                this.dimensionValues.add(extractionFn.apply(value));
                            }
                        }
                    }
                    catch (Throwable e) {
                        this.currentId = -1L;
                        throw e;
                    }
                    if (RowBasedColumnSelectorFactory.this.rowIdSupplier != null) {
                        this.currentId = RowBasedColumnSelectorFactory.this.rowIdSupplier.getRowId();
                    }
                }
            }
        };
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(final String columnName) {
        final ExpressionType expressionType = this.columnInspector.getType(columnName);
        if (columnName.equals("__time")) {
            final ToLongFunction<T> timestampFunction = this.adapter.timestampFunction();
            class TimeLongColumnSelector
            implements LongColumnSelector {
                TimeLongColumnSelector() {
                }

                @Override
                public long getLong() {
                    return timestampFunction.applyAsLong(RowBasedColumnSelectorFactory.this.rowSupplier.get());
                }

                @Override
                public boolean isNull() {
                    return false;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("row", RowBasedColumnSelectorFactory.this.rowSupplier);
                }
            }
            return new TimeLongColumnSelector();
        }
        if (expressionType != null && expressionType.is(ExprType.STRING)) {
            return this.makeDimensionSelector(DefaultDimensionSpec.of(columnName));
        }
        final Function<T, Object> columnFunction = this.adapter.columnFunction(columnName);
        ColumnCapabilities capabilities = this.columnInspector.getColumnCapabilities(columnName);
        final ValueType numberType = capabilities != null && ((ValueType)capabilities.getType()).isNumeric() ? (ValueType)capabilities.getType() : null;
        return new ColumnValueSelector<Object>(){
            private long currentValueId = -1L;
            private long currentValueAsNumberId = -1L;
            @Nullable
            private Object currentValue;
            @Nullable
            private Number currentValueAsNumber;

            @Override
            public boolean isNull() {
                this.updateCurrentValueAsNumber();
                return this.currentValueAsNumber == null;
            }

            @Override
            public double getDouble() {
                this.updateCurrentValueAsNumber();
                assert (this.currentValueAsNumber != null);
                return this.currentValueAsNumber.doubleValue();
            }

            @Override
            public float getFloat() {
                this.updateCurrentValueAsNumber();
                assert (this.currentValueAsNumber != null);
                return this.currentValueAsNumber.floatValue();
            }

            @Override
            public long getLong() {
                this.updateCurrentValueAsNumber();
                assert (this.currentValueAsNumber != null);
                return this.currentValueAsNumber.longValue();
            }

            @Override
            @Nullable
            public Object getObject() {
                this.updateCurrentValue();
                if (expressionType != null && !expressionType.is(ExprType.COMPLEX)) {
                    try {
                        Object val = ExprEval.bestEffortOf(this.currentValue).castTo(expressionType).value();
                        if (val != null && expressionType.is(ExprType.DOUBLE) && numberType == ValueType.FLOAT) {
                            return Float.valueOf(((Number)val).floatValue());
                        }
                        return val;
                    }
                    catch (Exception e) {
                        if (RowBasedColumnSelectorFactory.this.throwParseExceptions) {
                            throw new ParseException(String.valueOf(this.currentValue), "Error reading column[%s] as type[%s]", columnName, expressionType);
                        }
                        return this.currentValue;
                    }
                }
                return this.currentValue;
            }

            @Override
            public Class<Object> classOfObject() {
                return Object.class;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("row", RowBasedColumnSelectorFactory.this.rowSupplier);
            }

            private void updateCurrentValue() {
                if (RowBasedColumnSelectorFactory.this.rowIdSupplier == null || RowBasedColumnSelectorFactory.this.rowIdSupplier.getRowId() != this.currentValueId) {
                    try {
                        this.currentValue = columnFunction.apply(RowBasedColumnSelectorFactory.this.rowSupplier.get());
                    }
                    catch (Throwable e) {
                        this.currentValueId = -1L;
                        throw e;
                    }
                    if (RowBasedColumnSelectorFactory.this.rowIdSupplier != null) {
                        this.currentValueId = RowBasedColumnSelectorFactory.this.rowIdSupplier.getRowId();
                    }
                }
            }

            private void updateCurrentValueAsNumber() {
                this.updateCurrentValue();
                if (RowBasedColumnSelectorFactory.this.rowIdSupplier == null || RowBasedColumnSelectorFactory.this.rowIdSupplier.getRowId() != this.currentValueAsNumberId) {
                    try {
                        Object valueToUse = this.currentValue instanceof StructuredData ? ((StructuredData)this.currentValue).getValue() : this.currentValue;
                        this.currentValueAsNumber = Rows.objectToNumber(columnName, valueToUse, numberType, RowBasedColumnSelectorFactory.this.throwParseExceptions);
                    }
                    catch (Throwable e) {
                        this.currentValueAsNumberId = -1L;
                        throw e;
                    }
                    if (RowBasedColumnSelectorFactory.this.rowIdSupplier != null) {
                        this.currentValueAsNumberId = RowBasedColumnSelectorFactory.this.rowIdSupplier.getRowId();
                    }
                }
            }
        };
    }

    @Override
    @Nullable
    public RowIdSupplier getRowIdSupplier() {
        return this.rowIdSupplier;
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        return RowBasedColumnSelectorFactory.getColumnCapabilities(this.columnInspector, columnName);
    }

    private static boolean shouldCoerce(@Nullable Object obj, @Nullable ExpressionType expressionType) {
        return obj != null && expressionType != null && (!expressionType.is(ExprType.STRING) || !(obj instanceof List));
    }
}

