/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import org.apache.druid.error.DruidException;
import org.apache.druid.segment.ColumnValueSelector;

public abstract class ObjectBasedColumnSelector<T>
implements ColumnValueSelector<T> {
    private static final String COLUMN_IS_NULL_ERROR_MESSAGE = "Invalid usage pattern: method returning primitive called - but the column is null";

    @Override
    public final float getFloat() {
        Object value = this.getObject();
        if (value == null) {
            throw DruidException.defensive(COLUMN_IS_NULL_ERROR_MESSAGE, new Object[0]);
        }
        return ((Number)value).floatValue();
    }

    @Override
    public final double getDouble() {
        Object value = this.getObject();
        if (value == null) {
            throw DruidException.defensive(COLUMN_IS_NULL_ERROR_MESSAGE, new Object[0]);
        }
        return ((Number)value).doubleValue();
    }

    @Override
    public final long getLong() {
        Object value = this.getObject();
        if (value == null) {
            throw DruidException.defensive(COLUMN_IS_NULL_ERROR_MESSAGE, new Object[0]);
        }
        return ((Number)value).longValue();
    }

    @Override
    public final boolean isNull() {
        Object object = this.getObject();
        if (object == null) {
            return true;
        }
        if (object instanceof Number) {
            return false;
        }
        throw DruidException.defensive("isNull() may only be called in case the underlying object is a Number but it was [%s]", object.getClass().getName());
    }
}

