/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.firstlast;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.firstlast.SelectionPredicate;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public abstract class FirstLastVectorAggregator<RhsType, PairType extends SerializablePair<Long, RhsType>>
implements VectorAggregator {
    public static final int NULLITY_OFFSET = 8;
    public static final int VALUE_OFFSET = 9;
    @Nullable
    private final VectorValueSelector timeSelector;
    @Nullable
    private final VectorValueSelector valueSelector;
    @Nullable
    private final VectorObjectSelector objectSelector;
    private final SelectionPredicate selectionPredicate;

    public FirstLastVectorAggregator(@Nullable VectorValueSelector timeSelector, @Nullable VectorValueSelector valueSelector, @Nullable VectorObjectSelector objectSelector, SelectionPredicate selectionPredicate) {
        if (timeSelector != null) {
            Preconditions.checkArgument((valueSelector != null && objectSelector == null || valueSelector == null && objectSelector != null ? 1 : 0) != 0, (Object)"exactly one of 'valueSelector' and 'objectSelector' must be provided");
        }
        this.timeSelector = timeSelector;
        this.valueSelector = valueSelector;
        this.objectSelector = objectSelector;
        this.selectionPredicate = selectionPredicate;
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        if (this.timeSelector == null) {
            return;
        }
        if (this.objectSelector != null) {
            Object[] maybeFoldedObjects = this.objectSelector.getObjectVector();
            boolean[] timeNullityVector = this.timeSelector.getNullVector();
            long[] timeVector = this.timeSelector.getLongVector();
            Object selectedPair = null;
            for (int index = startRow; index < endRow; ++index) {
                PairType pair = this.readPairFromVectorSelectors(timeNullityVector, timeVector, maybeFoldedObjects, index);
                if (pair == null) continue;
                if (selectedPair == null) {
                    selectedPair = pair;
                    continue;
                }
                if (!this.selectionPredicate.apply((Long)((SerializablePair)pair).lhs, (Long)selectedPair.lhs)) continue;
                selectedPair = pair;
            }
            if (selectedPair != null && this.selectionPredicate.apply((Long)selectedPair.lhs, buf.getLong(position))) {
                if (selectedPair.rhs != null) {
                    this.putValue(buf, position, (Long)selectedPair.lhs, selectedPair.rhs);
                } else {
                    this.putNull(buf, position, (Long)selectedPair.lhs);
                }
            }
        } else {
            boolean[] timeNullityVector = this.timeSelector.getNullVector();
            long[] timeVector = this.timeSelector.getLongVector();
            boolean[] valueNullityVector = this.valueSelector.getNullVector();
            Integer selectedIndex = null;
            for (int index = startRow; index < endRow; ++index) {
                if (timeNullityVector != null && timeNullityVector[index]) continue;
                if (selectedIndex == null) {
                    selectedIndex = index;
                    continue;
                }
                if (!this.selectionPredicate.apply(timeVector[index], timeVector[selectedIndex])) continue;
                selectedIndex = index;
            }
            if (selectedIndex != null && this.selectionPredicate.apply(timeVector[selectedIndex], buf.getLong(position))) {
                if (valueNullityVector == null || !valueNullityVector[selectedIndex]) {
                    this.putValue(buf, position, timeVector[selectedIndex], this.valueSelector, selectedIndex);
                } else {
                    this.putNull(buf, position, timeVector[selectedIndex]);
                }
            }
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        if (this.timeSelector == null) {
            return;
        }
        if (this.objectSelector != null) {
            Object[] maybeFoldedObjects = this.objectSelector.getObjectVector();
            boolean[] timeNullityVector = this.timeSelector.getNullVector();
            long[] timeVector = this.timeSelector.getLongVector();
            for (int i = 0; i < numRows; ++i) {
                int position = positions[i] + positionOffset;
                int row = rows == null ? i : rows[i];
                PairType pair = this.readPairFromVectorSelectors(timeNullityVector, timeVector, maybeFoldedObjects, row);
                if (pair == null) continue;
                long lastTime = buf.getLong(position);
                if (!this.selectionPredicate.apply((Long)((SerializablePair)pair).lhs, lastTime)) continue;
                if (((SerializablePair)pair).rhs != null) {
                    this.putValue(buf, position, (Long)((SerializablePair)pair).lhs, ((SerializablePair)pair).rhs);
                    continue;
                }
                this.putNull(buf, position, (Long)((SerializablePair)pair).lhs);
            }
        } else {
            boolean[] timeNullityVector = this.timeSelector.getNullVector();
            long[] timeVector = this.timeSelector.getLongVector();
            boolean[] valueNullityVector = this.valueSelector.getNullVector();
            for (int i = 0; i < numRows; ++i) {
                int position = positions[i] + positionOffset;
                int row = rows == null ? i : rows[i];
                long lastTime = buf.getLong(position);
                if (timeNullityVector != null && timeNullityVector[row] || !this.selectionPredicate.apply(timeVector[row], lastTime)) continue;
                if (valueNullityVector == null || !valueNullityVector[row]) {
                    this.putValue(buf, position, timeVector[row], this.valueSelector, row);
                    continue;
                }
                this.putNull(buf, position, timeVector[row]);
            }
        }
    }

    protected abstract void putValue(ByteBuffer var1, int var2, long var3, RhsType var5);

    protected abstract void putValue(ByteBuffer var1, int var2, long var3, VectorValueSelector var5, int var6);

    protected abstract void putNull(ByteBuffer var1, int var2, long var3);

    protected abstract PairType readPairFromVectorSelectors(boolean[] var1, long[] var2, Object[] var3, int var4);

    @Override
    public void close() {
    }
}

