/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.BaseExprEvalVector;

public final class ExprEvalObjectVector
extends BaseExprEvalVector<Object[]> {
    @Nullable
    private long[] longs;
    @Nullable
    private double[] doubles;
    @Nullable
    private boolean[] numericNulls;
    private final ExpressionType type;

    public ExprEvalObjectVector(Object[] values, ExpressionType type) {
        super(values, null);
        this.type = type;
        if (type.isNumeric()) {
            throw DruidException.defensive("Expression of type[%s] is numeric", type);
        }
    }

    private void computeNumbers() {
        if (this.longs == null) {
            this.longs = new long[((Object[])this.values).length];
            this.doubles = new double[((Object[])this.values).length];
            this.numericNulls = new boolean[((Object[])this.values).length];
            boolean isString = this.type.is(ExprType.STRING);
            for (int i = 0; i < ((Object[])this.values).length; ++i) {
                if (isString) {
                    Number n = ExprEval.computeNumber(Evals.asString(((Object[])this.values)[i]));
                    if (n != null) {
                        this.longs[i] = n.longValue();
                        this.doubles[i] = n.doubleValue();
                        this.numericNulls[i] = false;
                        continue;
                    }
                    this.longs[i] = 0L;
                    this.doubles[i] = 0.0;
                    this.numericNulls[i] = true;
                    continue;
                }
                ExprEval valueEval = ExprEval.ofType(this.type, ((Object[])this.values)[i]).castTo(ExpressionType.DOUBLE);
                this.longs[i] = valueEval.asLong();
                this.doubles[i] = valueEval.asDouble();
                this.numericNulls[i] = valueEval.isNumericNull();
            }
        }
    }

    @Override
    @Nullable
    public boolean[] getNullVector() {
        this.computeNumbers();
        return this.numericNulls;
    }

    @Override
    public ExpressionType getType() {
        return this.type;
    }

    @Override
    public long[] getLongVector() {
        this.computeNumbers();
        return this.longs;
    }

    @Override
    public double[] getDoubleVector() {
        this.computeNumbers();
        return this.doubles;
    }

    @Override
    public Object[] getObjectVector() {
        return (Object[])this.values;
    }

    @Override
    public boolean elementAsBoolean(int index) {
        if (this.type.is(ExprType.STRING)) {
            return Evals.asBoolean((String)((Object[])this.values)[index]);
        }
        return ExprEval.ofType(this.type, ((Object[])this.values)[index]).asBoolean();
    }
}

