/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.report;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.indexer.report.TaskReportFileWriter;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.logger.Logger;

public class SingleFileTaskReportFileWriter
implements TaskReportFileWriter {
    private static final Logger log = new Logger(SingleFileTaskReportFileWriter.class);
    private final File reportsFile;
    private ObjectMapper objectMapper;

    public SingleFileTaskReportFileWriter(File reportsFile) {
        this.reportsFile = reportsFile;
    }

    @Override
    public void write(String taskId, TaskReport.ReportMap reports) {
        try (OutputStream outputStream = this.openReportOutputStream(taskId);){
            SingleFileTaskReportFileWriter.writeReportToStream(this.objectMapper, outputStream, reports);
        }
        catch (Exception e) {
            log.error(e, "Encountered exception in write().", new Object[0]);
        }
    }

    @Override
    public OutputStream openReportOutputStream(String taskId) throws IOException {
        File reportsFileParent = this.reportsFile.getParentFile();
        if (reportsFileParent != null) {
            FileUtils.mkdirp(reportsFileParent);
        }
        return Files.newOutputStream(this.reportsFile.toPath(), new OpenOption[0]);
    }

    @Override
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public File getReportsFile(String taskId) {
        return this.reportsFile;
    }

    public static void writeReportToStream(ObjectMapper objectMapper, OutputStream outputStream, TaskReport.ReportMap reports) throws Exception {
        objectMapper.writeValue(outputStream, (Object)reports);
    }
}

