/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.hll;

import java.nio.ByteBuffer;
import org.apache.druid.hll.HyperLogLogCollector;

public class VersionOneHyperLogLogCollector
extends HyperLogLogCollector {
    public static final byte VERSION = 1;
    public static final int REGISTER_OFFSET_BYTE = 1;
    public static final int NUM_NON_ZERO_REGISTERS_BYTE = 2;
    public static final int MAX_OVERFLOW_VALUE_BYTE = 4;
    public static final int MAX_OVERFLOW_REGISTER_BYTE = 5;
    public static final int HEADER_NUM_BYTES = 7;
    public static final int NUM_BYTES_FOR_DENSE_STORAGE = 1031;
    private static final ByteBuffer DEFAULT_STORAGE_BUFFER = ByteBuffer.wrap(new byte[]{1, 0, 0, 0, 0, 0, 0}).asReadOnlyBuffer();

    VersionOneHyperLogLogCollector() {
        super(DEFAULT_STORAGE_BUFFER.duplicate());
    }

    VersionOneHyperLogLogCollector(ByteBuffer buffer) {
        super(buffer);
    }

    @Override
    public byte getVersion() {
        return 1;
    }

    @Override
    public void setVersion(ByteBuffer buffer) {
        buffer.put(buffer.position(), (byte)1);
    }

    @Override
    public byte getRegisterOffset() {
        return this.getStorageBuffer().get(this.getInitPosition() + 1);
    }

    @Override
    public void setRegisterOffset(byte registerOffset) {
        this.getStorageBuffer().put(this.getInitPosition() + 1, registerOffset);
    }

    @Override
    public void setRegisterOffset(ByteBuffer buffer, byte registerOffset) {
        buffer.put(buffer.position() + 1, registerOffset);
    }

    @Override
    public short getNumNonZeroRegisters() {
        return this.getStorageBuffer().getShort(this.getInitPosition() + 2);
    }

    @Override
    public void setNumNonZeroRegisters(short numNonZeroRegisters) {
        this.getStorageBuffer().putShort(this.getInitPosition() + 2, numNonZeroRegisters);
    }

    @Override
    public void setNumNonZeroRegisters(ByteBuffer buffer, short numNonZeroRegisters) {
        buffer.putShort(buffer.position() + 2, numNonZeroRegisters);
    }

    @Override
    public byte getMaxOverflowValue() {
        return this.getStorageBuffer().get(this.getInitPosition() + 4);
    }

    @Override
    public void setMaxOverflowValue(byte value) {
        this.getStorageBuffer().put(this.getInitPosition() + 4, value);
    }

    @Override
    public void setMaxOverflowValue(ByteBuffer buffer, byte value) {
        buffer.put(buffer.position() + 4, value);
    }

    @Override
    public short getMaxOverflowRegister() {
        return this.getStorageBuffer().getShort(this.getInitPosition() + 5);
    }

    @Override
    public void setMaxOverflowRegister(short register) {
        this.getStorageBuffer().putShort(this.getInitPosition() + 5, register);
    }

    @Override
    public void setMaxOverflowRegister(ByteBuffer buffer, short register) {
        buffer.putShort(buffer.position() + 5, register);
    }

    @Override
    public int getNumHeaderBytes() {
        return 7;
    }

    @Override
    public int getNumBytesForDenseStorage() {
        return 1031;
    }

    @Override
    public int getPayloadBytePosition() {
        return this.getInitPosition() + 7;
    }

    @Override
    public int getPayloadBytePosition(ByteBuffer buffer) {
        return buffer.position() + 7;
    }
}

