/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.pac4j;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.pac4j.Pac4jSessionStore;
import org.apache.druid.server.security.AuthenticationResult;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultCallbackLogic;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.http.adapter.JEEHttpActionAdapter;

public class Pac4jFilter
implements Filter {
    private static final Logger LOGGER = new Logger(Pac4jFilter.class);
    private final Config pac4jConfig;
    private final Pac4jSessionStore sessionStore;
    private final String callbackPath;
    private final String name;
    private final String authorizerName;

    public Pac4jFilter(String name, String authorizerName, Config pac4jConfig, String callbackPath, String cookiePassphrase) {
        this.pac4jConfig = pac4jConfig;
        this.callbackPath = callbackPath;
        this.name = name;
        this.authorizerName = authorizerName;
        this.sessionStore = new Pac4jSessionStore(cookiePassphrase);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest.getAttribute("Druid-Authentication-Result") != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        JEEContext context = new JEEContext(request, response);
        if (request.getRequestURI().equals(this.callbackPath)) {
            DefaultCallbackLogic callbackLogic = new DefaultCallbackLogic();
            String originalUrl = (String)request.getSession().getAttribute("pac4j.originalUrl");
            String redirectUrl = originalUrl != null ? originalUrl : "/";
            callbackLogic.perform((WebContext)context, (SessionStore)this.sessionStore, this.pac4jConfig, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE, redirectUrl, null, null);
        } else {
            DefaultSecurityLogic securityLogic = new DefaultSecurityLogic();
            try {
                securityLogic.perform((WebContext)context, (SessionStore)this.sessionStore, this.pac4jConfig, (ctx, session, profiles, parameters) -> {
                    try {
                        if (profiles != null && !profiles.isEmpty()) {
                            String uid = ((UserProfile)profiles.iterator().next()).getId();
                            if (uid != null) {
                                AuthenticationResult authenticationResult = new AuthenticationResult(uid, this.authorizerName, this.name, null);
                                servletRequest.setAttribute("Druid-Authentication-Result", (Object)authenticationResult);
                                filterChain.doFilter(servletRequest, servletResponse);
                            }
                        } else {
                            LOGGER.warn("No profiles found after OIDC auth.", new Object[0]);
                        }
                    }
                    catch (IOException | ServletException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE, null, "none", null, new Object[0]);
            }
            catch (HttpAction e) {
                JEEHttpActionAdapter.INSTANCE.adapt(e, (WebContext)context);
            }
        }
    }

    public void destroy() {
    }
}

