/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.client.ServerViewUtil;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.query.CloneQueryMode;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.planning.ExecutionVertex;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryResource;
import org.apache.druid.server.QueryResourceQueryResultPusherFactory;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.ResourceIOReaderWriterFactory;
import org.apache.druid.server.http.security.StateResourceFilter;
import org.apache.druid.server.security.AuthorizerMapper;
import org.joda.time.Interval;

@Path(value="/druid/v2/")
public class BrokerQueryResource
extends QueryResource {
    private final TimelineServerView brokerServerView;

    @Inject
    public BrokerQueryResource(QueryLifecycleFactory queryLifecycleFactory, @Json ObjectMapper jsonMapper, QueryScheduler queryScheduler, AuthorizerMapper authorizerMapper, QueryResourceQueryResultPusherFactory queryResultPusherFactory, ResourceIOReaderWriterFactory resourceIOReaderWriterFactory, TimelineServerView brokerServerView) {
        super(queryLifecycleFactory, jsonMapper, queryScheduler, authorizerMapper, queryResultPusherFactory, resourceIOReaderWriterFactory);
        this.brokerServerView = brokerServerView;
    }

    @POST
    @Path(value="/candidates")
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile", "application/smile"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getQueryTargets(InputStream in, @QueryParam(value="pretty") String pretty, @QueryParam(value="numCandidates") @DefaultValue(value="-1") int numCandidates, @QueryParam(value="cloneQueryMode") @Nullable String cloneQueryModeString, @Context HttpServletRequest req) throws IOException {
        ResourceIOReaderWriterFactory.ResourceIOReaderWriter ioReaderWriter = this.resourceIOReaderWriterFactory.factorize(req, pretty != null);
        CloneQueryMode cloneQueryMode = (CloneQueryMode)QueryContexts.getAsEnum((String)"cloneQueryMode", (Object)cloneQueryModeString, CloneQueryMode.class, (Enum)QueryContexts.DEFAULT_CLONE_QUERY_MODE);
        try {
            Query query = (Query)ioReaderWriter.getRequestMapper().readValue(in, Query.class);
            ExecutionVertex ev = ExecutionVertex.of((Query)query);
            return ioReaderWriter.getResponseWriter().ok(ServerViewUtil.getTargetLocations(this.brokerServerView, ev.getBaseTableDataSource(), (List<Interval>)ev.getEffectiveQuerySegmentSpec().getIntervals(), numCandidates, cloneQueryMode));
        }
        catch (Exception e) {
            return ioReaderWriter.getResponseWriter().gotError(e);
        }
    }
}

