/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.model.CatalogUtils;

public abstract class ObjectFacade {
    public abstract Map<String, Object> properties();

    public Object property(String key) {
        return this.properties().get(key);
    }

    public boolean hasProperty(String key) {
        return this.properties().containsKey(key);
    }

    public boolean booleanProperty(String key) {
        Boolean value = CatalogUtils.safeCast(this.property(key), Boolean.class, key);
        return value == null ? false : value;
    }

    public String stringProperty(String key) {
        return CatalogUtils.safeCast(this.property(key), String.class, key);
    }

    public Integer intProperty(String key) {
        return CatalogUtils.safeCast(this.property(key), Integer.class, key);
    }

    public List<String> stringListProperty(String key) {
        return CatalogUtils.safeCast(this.property(key), List.class, key);
    }

    public Map<String, Object> mapProperty(String key) {
        return CatalogUtils.safeCast(this.property(key), Map.class, key);
    }
}

