/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.skife.jdbi.v2.ContainerBuilder;
import org.skife.jdbi.v2.ListContainerBuilder;
import org.skife.jdbi.v2.UnwrappedSingleValueFactory;
import org.skife.jdbi.v2.tweak.ContainerFactory;

class ContainerFactoryRegistry {
    private final Map<Class<?>, ContainerFactory<?>> cache = new ConcurrentHashMap();
    private final List<ContainerFactory> factories = new CopyOnWriteArrayList<ContainerFactory>();

    ContainerFactoryRegistry() {
        this.factories.add(new ListContainerFactory());
        this.factories.add(new SetContainerFactory());
        this.factories.add(new SortedSetContainerFactory());
        this.factories.add(new UnwrappedSingleValueFactory());
    }

    ContainerFactoryRegistry(ContainerFactoryRegistry parent) {
        this.cache.putAll(parent.cache);
        this.factories.addAll(parent.factories);
    }

    void register(ContainerFactory<?> factory) {
        this.factories.add(factory);
        this.cache.clear();
    }

    public ContainerFactoryRegistry createChild() {
        return new ContainerFactoryRegistry(this);
    }

    public ContainerBuilder createBuilderFor(Class<?> type) {
        if (this.cache.containsKey(type)) {
            return this.cache.get(type).newContainerBuilderFor(type);
        }
        for (int i = this.factories.size(); i > 0; --i) {
            ContainerFactory factory = this.factories.get(i - 1);
            if (!factory.accepts(type)) continue;
            this.cache.put(type, factory);
            return factory.newContainerBuilderFor(type);
        }
        throw new IllegalStateException("No container builder available for " + type.getName());
    }

    static class ListContainerFactory
    implements ContainerFactory<List<?>> {
        ListContainerFactory() {
        }

        @Override
        public boolean accepts(Class<?> type) {
            return type.equals(List.class) || type.equals(Collection.class) || type.equals(Iterable.class);
        }

        @Override
        public ContainerBuilder<List<?>> newContainerBuilderFor(Class<?> type) {
            return new ListContainerBuilder();
        }
    }

    static class SetContainerFactory
    implements ContainerFactory<Set<?>> {
        SetContainerFactory() {
        }

        @Override
        public boolean accepts(Class<?> type) {
            return Set.class.equals(type) || LinkedHashSet.class.equals(type);
        }

        @Override
        public ContainerBuilder<Set<?>> newContainerBuilderFor(Class<?> type) {
            return new ContainerBuilder<Set<?>>(){
                private Set<Object> s = new LinkedHashSet<Object>();

                @Override
                public ContainerBuilder<Set<?>> add(Object it) {
                    this.s.add(it);
                    return this;
                }

                @Override
                public Set<?> build() {
                    return this.s;
                }
            };
        }
    }

    static class SortedSetContainerFactory
    implements ContainerFactory<SortedSet<?>> {
        SortedSetContainerFactory() {
        }

        @Override
        public boolean accepts(Class<?> type) {
            return type.equals(SortedSet.class);
        }

        @Override
        public ContainerBuilder<SortedSet<?>> newContainerBuilderFor(Class<?> type) {
            return new ContainerBuilder<SortedSet<?>>(){
                private SortedSet<Object> s = new TreeSet<Object>();

                @Override
                public ContainerBuilder<SortedSet<?>> add(Object it) {
                    this.s.add(it);
                    return this;
                }

                @Override
                public SortedSet<?> build() {
                    return this.s;
                }
            };
        }
    }
}

