/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Random;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.CompactDoublesSketch;
import org.apache.datasketches.quantiles.DirectCompactDoublesSketch;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketch;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketchR;
import org.apache.datasketches.quantiles.DoublesByteArrayImpl;
import org.apache.datasketches.quantiles.DoublesMergeImpl;
import org.apache.datasketches.quantiles.DoublesSketchBuilder;
import org.apache.datasketches.quantiles.DoublesSketchIterator;
import org.apache.datasketches.quantiles.DoublesSketchSortedView;
import org.apache.datasketches.quantiles.DoublesUtil;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketch;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.quantilescommon.DoublesSortedView;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesDoublesAPI;
import org.apache.datasketches.quantilescommon.QuantilesDoublesSketchIterator;
import org.apache.datasketches.quantilescommon.QuantilesUtil;

public abstract class DoublesSketch
implements QuantilesDoublesAPI {
    static Random rand = new Random();
    final int k_;
    DoublesSketchSortedView classicQdsSV = null;

    DoublesSketch(int k) {
        ClassicUtil.checkK(k);
        this.k_ = k;
    }

    static synchronized void setRandom(long seed) {
        rand = new Random(seed);
    }

    public static final DoublesSketchBuilder builder() {
        return new DoublesSketchBuilder();
    }

    public static DoublesSketch heapify(Memory srcMem) {
        if (ClassicUtil.checkIsCompactMemory(srcMem)) {
            return CompactDoublesSketch.heapify(srcMem);
        }
        return UpdateDoublesSketch.heapify(srcMem);
    }

    public static DoublesSketch wrap(Memory srcMem) {
        if (ClassicUtil.checkIsCompactMemory(srcMem)) {
            return DirectCompactDoublesSketch.wrapInstance(srcMem);
        }
        return DirectUpdateDoublesSketchR.wrapInstance(srcMem);
    }

    @Override
    public double[] getCDF(double[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.classicQdsSV.getCDF(splitPoints, searchCrit);
    }

    @Override
    public abstract double getMaxItem();

    @Override
    public abstract double getMinItem();

    @Override
    public QuantilesDoublesAPI.DoublesPartitionBoundaries getPartitionBoundaries(int numEquallyWeighted, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        double[] ranks = QuantilesUtil.equallyWeightedRanks(numEquallyWeighted);
        double[] boundaries = this.getQuantiles(ranks, searchCrit);
        boundaries[0] = this.getMinItem();
        boundaries[boundaries.length - 1] = this.getMaxItem();
        QuantilesDoublesAPI.DoublesPartitionBoundaries dpb = new QuantilesDoublesAPI.DoublesPartitionBoundaries();
        dpb.N = this.getN();
        dpb.ranks = ranks;
        dpb.boundaries = boundaries;
        return dpb;
    }

    @Override
    public double[] getPMF(double[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.classicQdsSV.getPMF(splitPoints, searchCrit);
    }

    @Override
    public double getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.classicQdsSV.getQuantile(rank, searchCrit);
    }

    @Override
    public double[] getQuantiles(double[] ranks, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = ranks.length;
        double[] quantiles = new double[len];
        for (int i = 0; i < len; ++i) {
            quantiles[i] = this.classicQdsSV.getQuantile(ranks[i], searchCrit);
        }
        return quantiles;
    }

    @Override
    public double getQuantileLowerBound(double rank) {
        return this.getQuantile(Math.max(0.0, rank - DoublesSketch.getNormalizedRankError(this.k_, false)));
    }

    @Override
    public double getQuantileUpperBound(double rank) {
        return this.getQuantile(Math.min(1.0, rank + DoublesSketch.getNormalizedRankError(this.k_, false)));
    }

    @Override
    public double getRank(double quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.classicQdsSV.getRank(quantile, searchCrit);
    }

    @Override
    public double getRankLowerBound(double rank) {
        return Math.max(0.0, rank - DoublesSketch.getNormalizedRankError(this.k_, false));
    }

    @Override
    public double getRankUpperBound(double rank) {
        return Math.min(1.0, rank + DoublesSketch.getNormalizedRankError(this.k_, false));
    }

    @Override
    public double[] getRanks(double[] quantiles, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = quantiles.length;
        double[] ranks = new double[len];
        for (int i = 0; i < len; ++i) {
            ranks[i] = this.classicQdsSV.getRank(quantiles[i], searchCrit);
        }
        return ranks;
    }

    @Override
    public int getK() {
        return this.k_;
    }

    @Override
    public abstract long getN();

    public double getNormalizedRankError(boolean pmf) {
        return DoublesSketch.getNormalizedRankError(this.k_, pmf);
    }

    public static double getNormalizedRankError(int k, boolean pmf) {
        return ClassicUtil.getNormalizedRankError(k, pmf);
    }

    public static int getKFromEpsilon(double epsilon, boolean pmf) {
        return ClassicUtil.getKFromEpsilon(epsilon, pmf);
    }

    @Override
    public abstract boolean hasMemory();

    @Override
    public abstract boolean isDirect();

    @Override
    public boolean isEmpty() {
        return this.getN() == 0L;
    }

    @Override
    public boolean isEstimationMode() {
        return this.getN() >= 2L * (long)this.k_;
    }

    @Override
    public abstract boolean isReadOnly();

    public boolean isSameResource(Memory that) {
        return false;
    }

    @Override
    public byte[] toByteArray() {
        if (this.isCompact()) {
            return this.toByteArray(true);
        }
        return this.toByteArray(false);
    }

    public byte[] toByteArray(boolean compact) {
        return DoublesByteArrayImpl.toByteArray(this, compact, compact);
    }

    @Override
    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean sketchSummary, boolean dataDetail) {
        return DoublesUtil.toString(sketchSummary, dataDetail, this);
    }

    public static String toString(byte[] byteArr) {
        return PreambleUtil.toString(byteArr, true);
    }

    public static String toString(Memory mem) {
        return PreambleUtil.toString(mem, true);
    }

    public DoublesSketch downSample(DoublesSketch srcSketch, int smallerK, WritableMemory dstMem) {
        return this.downSampleInternal(srcSketch, smallerK, dstMem);
    }

    @Override
    public int getNumRetained() {
        return ClassicUtil.computeRetainedItems(this.getK(), this.getN());
    }

    public int getCurrentCompactSerializedSizeBytes() {
        return DoublesSketch.getCompactSerialiedSizeBytes(this.getK(), this.getN());
    }

    public static int getCompactSerialiedSizeBytes(int k, long n) {
        if (n == 0L) {
            return 8;
        }
        int metaPreLongs = ClassicUtil.MAX_PRELONGS + 2;
        return metaPreLongs + ClassicUtil.computeRetainedItems(k, n) << 3;
    }

    @Override
    public int getSerializedSizeBytes() {
        if (this.isCompact()) {
            return this.getCurrentCompactSerializedSizeBytes();
        }
        return this.getCurrentUpdatableSerializedSizeBytes();
    }

    public int getCurrentUpdatableSerializedSizeBytes() {
        return DoublesSketch.getUpdatableStorageBytes(this.getK(), this.getN());
    }

    public static int getUpdatableStorageBytes(int k, long n) {
        if (n == 0L) {
            return 8;
        }
        int metaPre = ClassicUtil.MAX_PRELONGS + 2;
        int totLevels = ClassicUtil.computeNumLevelsNeeded(k, n);
        if (n <= (long)k) {
            int ceil = Math.max(Util.ceilingIntPowerOf2((int)n), 4);
            return metaPre + ceil << 3;
        }
        return metaPre + (2 + totLevels) * k << 3;
    }

    public void putMemory(WritableMemory dstMem) {
        this.putMemory(dstMem, true);
    }

    public void putMemory(WritableMemory dstMem, boolean compact) {
        if (this.hasMemory() && this.isCompact() == compact) {
            WritableMemory srcMem = this.getMemory();
            srcMem.copyTo(0L, dstMem, 0L, (long)this.getSerializedSizeBytes());
        } else {
            byte[] byteArr = this.toByteArray(compact);
            int arrLen = byteArr.length;
            long memCap = dstMem.getCapacity();
            if (memCap < (long)arrLen) {
                throw new SketchesArgumentException("Destination Memory not large enough: " + memCap + " < " + arrLen);
            }
            dstMem.putByteArray(0L, byteArr, 0, arrLen);
        }
    }

    @Override
    public QuantilesDoublesSketchIterator iterator() {
        return new DoublesSketchIterator(this, this.getBitPattern());
    }

    @Override
    public DoublesSortedView getSortedView() {
        return new DoublesSketchSortedView(this);
    }

    @Override
    public abstract void reset();

    UpdateDoublesSketch downSampleInternal(DoublesSketch srcSketch, int smallerK, WritableMemory dstMem) {
        UpdateDoublesSketch newSketch;
        UpdateDoublesSketch updateDoublesSketch = newSketch = dstMem == null ? HeapUpdateDoublesSketch.newInstance(smallerK) : DirectUpdateDoublesSketch.newInstance(smallerK, dstMem);
        if (srcSketch.isEmpty()) {
            return newSketch;
        }
        DoublesMergeImpl.downSamplingMergeInto(srcSketch, newSketch);
        return newSketch;
    }

    private final void refreshSortedView() {
        this.classicQdsSV = this.classicQdsSV == null ? new DoublesSketchSortedView(this) : this.classicQdsSV;
    }

    abstract boolean isCompact();

    abstract int getBaseBufferCount();

    abstract long getBitPattern();

    abstract int getCombinedBufferItemCapacity();

    abstract double[] getCombinedBuffer();

    abstract WritableMemory getMemory();
}

