/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSetOperationBuilder;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketches;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUnion;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;

public class ArrayOfDoublesSketchMergeBufferAggregator
implements BufferAggregator {
    private final BaseObjectColumnValueSelector<ArrayOfDoublesSketch> selector;
    private final int nominalEntries;
    private final int numberOfValues;
    private final int maxIntermediateSize;

    public ArrayOfDoublesSketchMergeBufferAggregator(BaseObjectColumnValueSelector<ArrayOfDoublesSketch> selector, int nominalEntries, int numberOfValues, int maxIntermediateSize) {
        this.selector = selector;
        this.nominalEntries = nominalEntries;
        this.numberOfValues = numberOfValues;
        this.maxIntermediateSize = maxIntermediateSize;
    }

    public void init(ByteBuffer buf, int position) {
        WritableMemory mem = WritableMemory.writableWrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        new ArrayOfDoublesSetOperationBuilder().setNominalEntries(this.nominalEntries).setNumberOfValues(this.numberOfValues).buildUnion(region);
    }

    public void aggregate(ByteBuffer buf, int position) {
        ArrayOfDoublesSketch update = (ArrayOfDoublesSketch)this.selector.getObject();
        if (update == null) {
            return;
        }
        WritableMemory mem = WritableMemory.writableWrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        ArrayOfDoublesUnion union = ArrayOfDoublesSketches.wrapUnion((WritableMemory)region);
        union.union(update);
    }

    public Object get(ByteBuffer buf, int position) {
        WritableMemory mem = WritableMemory.writableWrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        ArrayOfDoublesUnion union = ArrayOfDoublesSketches.wrapUnion((WritableMemory)region);
        return union.getResult();
    }

    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
    }
}

