/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchBuildBufferAggregatorHelper;
import org.apache.druid.query.monomorphicprocessing.HotLoopCallee;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;

public class DoublesSketchBuildBufferAggregator
implements BufferAggregator {
    private final BaseDoubleColumnValueSelector selector;
    private final DoublesSketchBuildBufferAggregatorHelper helper;

    public DoublesSketchBuildBufferAggregator(BaseDoubleColumnValueSelector valueSelector, int size, int maxIntermediateSize) {
        this.selector = valueSelector;
        this.helper = new DoublesSketchBuildBufferAggregatorHelper(size, maxIntermediateSize);
    }

    public void init(ByteBuffer buf, int position) {
        this.helper.init(buf, position);
    }

    public void aggregate(ByteBuffer buffer, int position) {
        if (this.selector.isNull()) {
            return;
        }
        UpdateDoublesSketch sketch = this.helper.getSketchAtPosition(buffer, position);
        sketch.update(this.selector.getDouble());
    }

    @Nullable
    public Object get(ByteBuffer buf, int position) {
        return this.helper.get(buf, position);
    }

    public float getFloat(ByteBuffer buffer, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public long getLong(ByteBuffer buffer, int position) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void close() {
        this.helper.clear();
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        this.helper.relocate(oldPosition, newPosition, oldBuffer, newBuffer);
    }

    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", (HotLoopCallee)this.selector);
    }
}

