/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.logical;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.error.DruidException;
import org.apache.druid.msq.exec.StageProcessor;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.kernel.MixShuffleSpec;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.StageDefinitionBuilder;
import org.apache.druid.msq.logical.LogicalInputSpec;
import org.apache.druid.msq.logical.stages.AbstractFrameProcessorStage;
import org.apache.druid.msq.logical.stages.AbstractShuffleStage;
import org.apache.druid.msq.logical.stages.LogicalStage;
import org.apache.druid.msq.querykit.scan.ScanQueryStageProcessor;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class StageMaker {
    private int stageIdSeq = 0;
    private final PlannerContext plannerContext;
    private Map<LogicalStage, StageDefinitionBuilder> builtStages = new IdentityHashMap<LogicalStage, StageDefinitionBuilder>();

    public StageMaker(PlannerContext plannerContext) {
        this.plannerContext = plannerContext;
    }

    public static ScanQueryStageProcessor makeScanStageProcessor(VirtualColumns virtualColumns, RowSignature signature, DimFilter dimFilter) {
        return ScanQueryStageProcessor.makeScanStageProcessor(virtualColumns, signature, dimFilter);
    }

    public StageDefinitionBuilder buildStage(LogicalStage stage) {
        if (this.builtStages.get(stage) != null) {
            return this.builtStages.get(stage);
        }
        StageDefinitionBuilder stageDef = this.buildStageInternal(stage);
        this.builtStages.put(stage, stageDef);
        return stageDef;
    }

    private StageDefinitionBuilder buildStageInternal(LogicalStage stage) {
        if (stage instanceof AbstractFrameProcessorStage) {
            return this.buildFrameProcessorStage((AbstractFrameProcessorStage)stage);
        }
        if (stage instanceof AbstractShuffleStage) {
            return this.buildShuffleStage((AbstractShuffleStage)stage);
        }
        throw DruidException.defensive((String)"Cannot build type [%s]", (Object[])new Object[]{stage.getClass().getSimpleName()});
    }

    private StageDefinitionBuilder buildFrameProcessorStage(AbstractFrameProcessorStage frameProcessorStage) {
        List<LogicalInputSpec> inputs = frameProcessorStage.getInputSpecs();
        StageDefinitionBuilder sdb = this.newStageDefinitionBuilder(inputs);
        StageProcessor<?, ?> stageProcessor = frameProcessorStage.buildStageProcessor(this);
        sdb.signature(frameProcessorStage.getLogicalRowSignature());
        sdb.processor(stageProcessor);
        sdb.shuffleSpec(MixShuffleSpec.instance());
        return sdb;
    }

    private StageDefinitionBuilder buildShuffleStage(AbstractShuffleStage stage) {
        List<LogicalInputSpec> inputs = stage.getInputSpecs();
        StageDefinitionBuilder sdb = this.newStageDefinitionBuilder(inputs);
        sdb.signature(stage.getRowSignature());
        sdb.processor(StageMaker.makeScanStageProcessor(VirtualColumns.EMPTY, stage.getRowSignature(), null));
        sdb.shuffleSpec(stage.buildShuffleSpec());
        return sdb;
    }

    private StageDefinitionBuilder newStageDefinitionBuilder(List<LogicalInputSpec> inputs) {
        ArrayList<InputSpec> inputSpecs = new ArrayList<InputSpec>();
        HashSet<Integer> broadcastInputs = new HashSet<Integer>();
        for (int i = 0; i < inputs.size(); ++i) {
            LogicalInputSpec dagInputSpec = inputs.get(i);
            inputSpecs.add(dagInputSpec.toInputSpec(this));
            if (!dagInputSpec.hasProperty(LogicalInputSpec.InputProperty.BROADCAST)) continue;
            broadcastInputs.add(i);
        }
        StageDefinitionBuilder sdb = StageDefinition.builder(this.getNextStageId());
        sdb.broadcastInputs(broadcastInputs);
        sdb.inputs(inputSpecs);
        return sdb;
    }

    private int getNextStageId() {
        return this.stageIdSeq++;
    }

    public QueryDefinition buildQueryDefinition() {
        return QueryDefinition.create(this.makeStages(), this.plannerContext.queryContext());
    }

    private List<StageDefinition> makeStages() {
        ArrayList<StageDefinition> ret = new ArrayList<StageDefinition>();
        for (StageDefinitionBuilder stageDefinitionBuilder : this.builtStages.values()) {
            ret.add(stageDefinitionBuilder.build(this.getIdForBuilder()));
        }
        ret.sort(Comparator.comparing(StageDefinition::getStageNumber));
        return ret;
    }

    private String getIdForBuilder() {
        String dartQueryId = this.plannerContext.queryContext().getString("dartQueryId");
        if (dartQueryId != null) {
            return dartQueryId;
        }
        return this.plannerContext.getSqlQueryId();
    }

    public StageProcessor<?, ?> makeSegmentMapProcessor(RowSignature signature, DataSource dataSource) {
        return ScanQueryStageProcessor.makeSegmentMapFnProcessor(signature, dataSource);
    }
}

