/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.destination;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Optional;
import org.apache.druid.msq.indexing.destination.MSQDestination;
import org.apache.druid.msq.indexing.destination.MSQSelectDestination;
import org.apache.druid.msq.querykit.ShuffleSpecFactories;
import org.apache.druid.msq.querykit.ShuffleSpecFactory;
import org.apache.druid.server.security.Resource;

public class DurableStorageMSQDestination
implements MSQDestination {
    public static final String TYPE = "durableStorage";
    public static final DurableStorageMSQDestination INSTANCE = new DurableStorageMSQDestination();

    private DurableStorageMSQDestination() {
    }

    @JsonCreator
    public static DurableStorageMSQDestination instance() {
        return INSTANCE;
    }

    public String toString() {
        return "DurableStorageDestination{}";
    }

    @Override
    public ShuffleSpecFactory getShuffleSpecFactory(int targetSize) {
        return ShuffleSpecFactories.getGlobalSortWithTargetSize(targetSize);
    }

    @Override
    public Optional<Resource> getDestinationResource() {
        return Optional.of(new Resource("__query_select", "DATASOURCE"));
    }

    @Override
    public long getRowsInTaskReport() {
        return 3000L;
    }

    @Override
    public MSQSelectDestination toSelectDestination() {
        return MSQSelectDestination.DURABLESTORAGE;
    }
}

