/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec.std;

import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.ArenaMemoryAllocatorFactory;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.channel.BlockingQueueFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.frame.processor.Bouncer;
import org.apache.druid.frame.processor.FrameChannelHashPartitioner;
import org.apache.druid.frame.processor.FrameChannelMixer;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessorDecorator;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.OutputChannels;
import org.apache.druid.frame.processor.PartitionedOutputChannel;
import org.apache.druid.frame.processor.SuperSorter;
import org.apache.druid.frame.processor.SuperSorterProgressTracker;
import org.apache.druid.frame.processor.manager.ProcessorManagers;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.msq.exec.ExecutionContext;
import org.apache.druid.msq.exec.WorkerMemoryParameters;
import org.apache.druid.msq.exec.std.ResultAndChannels;
import org.apache.druid.msq.indexing.processor.KeyStatisticsCollectionProcessor;
import org.apache.druid.msq.kernel.ShuffleSpec;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.statistics.ClusterByStatisticsCollector;
import org.apache.druid.msq.statistics.ClusterByStatisticsSnapshot;
import org.apache.druid.segment.column.RowSignature;

public class StandardShuffleOperations {
    private final ExecutionContext executionContext;
    private final WorkOrder workOrder;

    public StandardShuffleOperations(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.workOrder = executionContext.workOrder();
    }

    public <T> ListenableFuture<ResultAndChannels<Object>> mix(ListenableFuture<ResultAndChannels<T>> inFuture, OutputChannelFactory outputChannelFactory) {
        return StandardShuffleOperations.transformAsync(inFuture, in -> {
            OutputChannel outputChannel = outputChannelFactory.openChannel(0);
            FrameChannelMixer mixer = new FrameChannelMixer(in.outputChannels().getAllReadableChannels(), outputChannel.getWritableChannel());
            ResultAndChannels retVal = new ResultAndChannels(this.executionContext.executor().runFully(this.executionContext.counters().trackCpu(mixer, "mixOutput"), this.executionContext.cancellationId()), OutputChannels.wrap(Collections.singletonList(outputChannel.readOnly())));
            if (outputChannelFactory.isBuffered()) {
                return FutureUtils.transform(retVal.resultFuture(), (T ignored) -> retVal);
            }
            return Futures.immediateFuture(retVal);
        });
    }

    public <T> ListenableFuture<ResultAndChannels<Object>> gatherResultKeyStatisticsIfNeeded(ListenableFuture<ResultAndChannels<T>> inFuture) {
        return StandardShuffleOperations.transform(inFuture, in -> {
            StageDefinition stageDefinition = this.workOrder.getStageDefinition();
            OutputChannels channels = in.outputChannels();
            if (channels.getAllChannels().isEmpty()) {
                if (stageDefinition.mustGatherResultKeyStatistics()) {
                    this.executionContext.onDoneReadingInput(ClusterByStatisticsSnapshot.empty());
                } else {
                    this.executionContext.onDoneReadingInput(null);
                }
                BlockingQueueFrameChannel channel = BlockingQueueFrameChannel.minimal();
                channel.writable().close();
                OutputChannel outputChannel = OutputChannel.readOnly((ReadableFrameChannel)channel.readable(), (int)-1);
                return new ResultAndChannels(Futures.immediateFuture(null), OutputChannels.wrap(Collections.singletonList(outputChannel)));
            }
            if (stageDefinition.mustGatherResultKeyStatistics()) {
                return this.gatherResultKeyStatistics(channels);
            }
            in.resultFuture().addListener(() -> this.executionContext.onDoneReadingInput(null), (Executor)Execs.directExecutor());
            return in;
        });
    }

    public <T> ListenableFuture<ResultAndChannels<Object>> globalSort(ListenableFuture<ResultAndChannels<T>> inFuture, OutputChannelFactory outputChannelFactory) {
        return StandardShuffleOperations.transformAsync(inFuture, in -> {
            StageDefinition stageDefinition = this.workOrder.getStageDefinition();
            WorkerMemoryParameters memoryParameters = this.executionContext.frameContext().memoryParameters();
            SuperSorter sorter = new SuperSorter(in.outputChannels().getAllReadableChannels(), stageDefinition.getFrameReader(), stageDefinition.getSortKey(), this.executionContext.globalClusterByPartitions(), this.executionContext.executor(), new FrameProcessorDecorator(){

                public <T2> FrameProcessor<T2> decorate(FrameProcessor<T2> processor) {
                    return StandardShuffleOperations.this.executionContext.counters().trackCpu(processor, "sortOutput");
                }
            }, outputChannelFactory, this.executionContext.makeIntermediateOutputChannelFactory("super-sort"), this.executionContext.frameContext().frameWriterSpec().getRowBasedFrameType(), memoryParameters.getSuperSorterConcurrentProcessors(), memoryParameters.getSuperSorterMaxChannelsPerMerger(), stageDefinition.getShuffleSpec().limitHint(), this.executionContext.cancellationId(), this.executionContext.counters().sortProgress(), this.executionContext.frameContext().frameWriterSpec().getRemoveNullBytes());
            return FutureUtils.transform((ListenableFuture)sorter.run(), (T sortedChannels) -> new ResultAndChannels(Futures.immediateFuture(null), (OutputChannels)sortedChannels));
        });
    }

    public <T> ListenableFuture<ResultAndChannels<Object>> hashPartition(ListenableFuture<ResultAndChannels<T>> inFuture, OutputChannelFactory outputChannelFactory) {
        return StandardShuffleOperations.transformAsync(inFuture, in -> {
            ShuffleSpec shuffleSpec = this.workOrder.getStageDefinition().getShuffleSpec();
            int partitions = shuffleSpec.partitionCount();
            ArrayList<OutputChannel> outputChannels = new ArrayList<OutputChannel>();
            for (int i = 0; i < partitions; ++i) {
                outputChannels.add(outputChannelFactory.openChannel(i));
            }
            FrameChannelHashPartitioner partitioner = new FrameChannelHashPartitioner(in.outputChannels().getAllReadableChannels(), outputChannels.stream().map(OutputChannel::getWritableChannel).collect(Collectors.toList()), this.workOrder.getStageDefinition().getFrameReader(), this.workOrder.getStageDefinition().getClusterBy().getColumns().size(), FrameWriters.makeFrameWriterFactory((FrameType)this.executionContext.frameContext().frameWriterSpec().getRowBasedFrameType(), (MemoryAllocatorFactory)new ArenaMemoryAllocatorFactory(this.executionContext.frameContext().memoryParameters().getFrameSize()), (RowSignature)this.workOrder.getStageDefinition().getSignature(), this.workOrder.getStageDefinition().getSortKey(), (boolean)this.executionContext.frameContext().frameWriterSpec().getRemoveNullBytes()));
            ListenableFuture partitionerFuture = this.executionContext.executor().runFully(this.executionContext.counters().trackCpu(partitioner, "hashPartitionOutput"), this.executionContext.cancellationId());
            ResultAndChannels retVal = new ResultAndChannels(partitionerFuture, OutputChannels.wrap(outputChannels));
            if (outputChannelFactory.isBuffered()) {
                return FutureUtils.transform((ListenableFuture)partitionerFuture, (T ignored) -> retVal);
            }
            return Futures.immediateFuture(retVal);
        });
    }

    public <T> ListenableFuture<ResultAndChannels<Object>> localSort(ListenableFuture<ResultAndChannels<T>> inFuture, final OutputChannelFactory outputChannelFactory) {
        return StandardShuffleOperations.transformAsync(inFuture, in -> {
            StageDefinition stageDefinition = this.workOrder.getStageDefinition();
            OutputChannels channels = in.outputChannels();
            ArrayList<ListenableFuture> sortedChannelFutures = new ArrayList<ListenableFuture>();
            ListenableFuture nextFuture = Futures.immediateFuture(null);
            for (final OutputChannel channel : channels.getAllChannels()) {
                File sorterTmpDir = this.executionContext.frameContext().tempDir(StringUtils.format((String)"hash-parts-super-sort-%06d", (Object[])new Object[]{channel.getPartitionNumber()}));
                FileUtils.mkdirp((File)sorterTmpDir);
                OutputChannelFactory partitionOverrideOutputChannelFactory = new OutputChannelFactory(){

                    public OutputChannel openChannel(int expectedZero) throws IOException {
                        if (expectedZero != 0) {
                            throw new ISE("Unexpected part [%s]", new Object[]{expectedZero});
                        }
                        return outputChannelFactory.openChannel(channel.getPartitionNumber());
                    }

                    public PartitionedOutputChannel openPartitionedChannel(String name, boolean deleteAfterRead) {
                        throw new UnsupportedOperationException();
                    }

                    public OutputChannel openNilChannel(int expectedZero) {
                        if (expectedZero != 0) {
                            throw new ISE("Unexpected part [%s]", new Object[]{expectedZero});
                        }
                        return outputChannelFactory.openNilChannel(channel.getPartitionNumber());
                    }

                    public boolean isBuffered() {
                        return outputChannelFactory.isBuffered();
                    }
                };
                nextFuture = Futures.transformAsync((ListenableFuture)nextFuture, ignored -> {
                    WorkerMemoryParameters memoryParameters = this.executionContext.frameContext().memoryParameters();
                    SuperSorter sorter = new SuperSorter(Collections.singletonList(channel.getReadableChannel()), stageDefinition.getFrameReader(), stageDefinition.getSortKey(), Futures.immediateFuture((Object)ClusterByPartitions.oneUniversalPartition()), this.executionContext.executor(), new FrameProcessorDecorator(){

                        public <T2> FrameProcessor<T2> decorate(FrameProcessor<T2> processor) {
                            return StandardShuffleOperations.this.executionContext.counters().trackCpu(processor, "sortOutput");
                        }
                    }, partitionOverrideOutputChannelFactory, this.executionContext.makeIntermediateOutputChannelFactory(StringUtils.format((String)"hash-parts-super-sort-%06d", (Object[])new Object[]{channel.getPartitionNumber()})), this.executionContext.frameContext().frameWriterSpec().getRowBasedFrameType(), memoryParameters.getSuperSorterConcurrentProcessors(), memoryParameters.getSuperSorterMaxChannelsPerMerger(), -1L, this.executionContext.cancellationId(), new SuperSorterProgressTracker(), this.executionContext.frameContext().frameWriterSpec().getRemoveNullBytes());
                    return FutureUtils.transform((ListenableFuture)sorter.run(), (T r) -> (OutputChannel)Iterables.getOnlyElement((Iterable)r.getAllChannels()));
                }, (Executor)MoreExecutors.directExecutor());
                sortedChannelFutures.add(nextFuture);
            }
            return FutureUtils.transform((ListenableFuture)Futures.allAsList(sortedChannelFutures), (T sortedChannels) -> new ResultAndChannels(Futures.immediateFuture(null), OutputChannels.wrap((List)sortedChannels)));
        });
    }

    private ResultAndChannels<ClusterByStatisticsCollector> gatherResultKeyStatistics(OutputChannels channels) {
        StageDefinition stageDefinition = this.workOrder.getStageDefinition();
        ArrayList<OutputChannel> retVal = new ArrayList<OutputChannel>();
        int numOutputChannels = channels.getAllChannels().size();
        ArrayList<KeyStatisticsCollectionProcessor> processors = new ArrayList<KeyStatisticsCollectionProcessor>(numOutputChannels);
        FrameType frameType = this.executionContext.frameContext().frameWriterSpec().getRowBasedFrameType();
        int maxRetainedBytes = this.executionContext.frameContext().memoryParameters().getPartitionStatisticsMaxRetainedBytes();
        int maxRetainedBytesPerChannel = maxRetainedBytes / 2 / numOutputChannels;
        for (OutputChannel outputChannel : channels.getAllChannels()) {
            BlockingQueueFrameChannel channel = BlockingQueueFrameChannel.minimal();
            retVal.add(OutputChannel.readOnly((ReadableFrameChannel)channel.readable(), (int)outputChannel.getPartitionNumber()));
            processors.add(new KeyStatisticsCollectionProcessor(outputChannel.getReadableChannel(), channel.writable(), stageDefinition.getFrameReader(), stageDefinition.getClusterBy(), stageDefinition.createResultKeyStatisticsCollector(frameType, maxRetainedBytesPerChannel)));
        }
        ListenableFuture clusterByStatisticsCollectorFuture = this.executionContext.executor().runAllFully(this.executionContext.counters().trackCpu(ProcessorManagers.of(processors).withAccumulation((Object)stageDefinition.createResultKeyStatisticsCollector(frameType, maxRetainedBytes / 2), ClusterByStatisticsCollector::addAll), "collectKeyStatistics"), processors.size(), Bouncer.unlimited(), this.executionContext.cancellationId());
        Futures.addCallback((ListenableFuture)clusterByStatisticsCollectorFuture, (FutureCallback)new FutureCallback<ClusterByStatisticsCollector>(){

            public void onSuccess(ClusterByStatisticsCollector result) {
                StandardShuffleOperations.this.executionContext.onDoneReadingInput(result.snapshot());
            }

            public void onFailure(Throwable t) {
            }
        }, (Executor)Execs.directExecutor());
        return new ResultAndChannels<ClusterByStatisticsCollector>(clusterByStatisticsCollectorFuture, OutputChannels.wrap(retVal));
    }

    private static <T, R> ListenableFuture<ResultAndChannels<Object>> transform(ListenableFuture<ResultAndChannels<T>> resultAndChannels, ExceptionalFunction<ResultAndChannels<T>, ResultAndChannels<R>> fn) {
        return StandardShuffleOperations.transformAsync(resultAndChannels, channels -> Futures.immediateFuture((Object)((ResultAndChannels)fn.apply((ResultAndChannels)channels))));
    }

    private static <T, R> ListenableFuture<ResultAndChannels<Object>> transformAsync(ListenableFuture<ResultAndChannels<T>> resultAndChannels, ExceptionalFunction<ResultAndChannels<T>, ListenableFuture<ResultAndChannels<R>>> fn) {
        ListenableFuture retVal = FutureUtils.transform((ListenableFuture)FutureUtils.transformAsync(resultAndChannels, fn::apply), (T newResultAndChannels) -> new ResultAndChannels(newResultAndChannels.resultFuture(), newResultAndChannels.outputChannels()));
        return retVal;
    }

    private static interface ExceptionalFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

