/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.TooManyClusteredByColumnsFault;
import org.apache.druid.msq.indexing.error.TooManyColumnsFault;
import org.apache.druid.msq.indexing.error.TooManyWorkersFault;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.StageDefinition;

public class QueryValidator {
    public static void validateQueryDef(QueryDefinition queryDef) {
        for (StageDefinition stageDef : queryDef.getStageDefinitions()) {
            int numColumns = stageDef.getSignature().size();
            if (numColumns > 2000) {
                throw new MSQException(new TooManyColumnsFault(numColumns, 2000));
            }
            int numClusteredByColumns = stageDef.getClusterBy().getColumns().size();
            if (numClusteredByColumns > 1500) {
                throw new MSQException(new TooManyClusteredByColumnsFault(numClusteredByColumns, 1500, stageDef.getStageNumber()));
            }
            int numWorkers = stageDef.getMaxWorkerCount();
            if (numWorkers > 1000) {
                throw new MSQException(new TooManyWorkersFault(numWorkers, 1000));
            }
            if (numWorkers > 0) continue;
            throw new ISE("Number of workers must be greater than 0", new Object[0]);
        }
    }
}

