/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.DescribeDBProxiesRequest;
import com.amazonaws.services.rds.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeDBProxiesRequestMarshaller
implements Marshaller<Request<DescribeDBProxiesRequest>, DescribeDBProxiesRequest> {
    public Request<DescribeDBProxiesRequest> marshall(DescribeDBProxiesRequest describeDBProxiesRequest) {
        if (describeDBProxiesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBProxiesRequest, "AmazonRDS");
        request.addParameter("Action", "DescribeDBProxies");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBProxiesRequest.getDBProxyName() != null) {
            request.addParameter("DBProxyName", StringUtils.fromString((String)describeDBProxiesRequest.getDBProxyName()));
        }
        if (!describeDBProxiesRequest.getFilters().isEmpty() || !((SdkInternalList)describeDBProxiesRequest.getFilters()).isAutoConstruct()) {
            SdkInternalList filtersList = (SdkInternalList)describeDBProxiesRequest.getFilters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue != null) {
                    if (filtersListValue.getName() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                    }
                    if (!filtersListValue.getValues().isEmpty() || !((SdkInternalList)filtersListValue.getValues()).isAutoConstruct()) {
                        SdkInternalList valuesList = (SdkInternalList)filtersListValue.getValues();
                        int valuesListIndex = 1;
                        for (String valuesListValue : valuesList) {
                            if (valuesListValue != null) {
                                request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                            }
                            ++valuesListIndex;
                        }
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDBProxiesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBProxiesRequest.getMarker()));
        }
        if (describeDBProxiesRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBProxiesRequest.getMaxRecords()));
        }
        return request;
    }
}

