/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.indexing.common.actions.RemoteTaskActionClientFactory;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.GlobalTaskLockbox;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.testing.cluster.ClusterTestingTaskConfig;
import org.apache.druid.testing.cluster.overlord.FaultyLagAggregator;
import org.apache.druid.testing.cluster.overlord.FaultyTaskLockbox;
import org.apache.druid.testing.cluster.task.FaultyCoordinatorClient;
import org.apache.druid.testing.cluster.task.FaultyOverlordClient;
import org.apache.druid.testing.cluster.task.FaultyRemoteTaskActionClientFactory;

public class ClusterTestingModule
implements DruidModule {
    private static final Logger log = new Logger(ClusterTestingModule.class);
    private static final String PROPERTY_ENABLE = "druid.unsafe.cluster.testing";
    private static final String PROPERTY_OVERLORD_CLIENT_CONFIG = "druid.unsafe.cluster.testing.overlordClient";
    private Set<NodeRole> roles;
    private boolean isClusterTestingEnabled = false;

    @Inject
    public void configure(Properties props, @Self Set<NodeRole> roles) {
        this.isClusterTestingEnabled = Boolean.parseBoolean(props.getProperty(PROPERTY_ENABLE, "false"));
        this.roles = roles;
    }

    public void configure(Binder binder) {
        if (this.isClusterTestingEnabled) {
            log.warn("Running service with roles[%s] in cluster testing mode. This is an unsafe test-only mode and must never be used in a production cluster. Set property[%s=false] to disable testing mode.", new Object[]{this.roles, PROPERTY_ENABLE});
            this.bindDependenciesForClusterTestingMode(binder);
        } else {
            log.info("Cluster testing is disabled. Set property[%s=true] to enable it.", new Object[]{PROPERTY_ENABLE});
        }
    }

    private void bindDependenciesForClusterTestingMode(Binder binder) {
        if (this.roles.equals(Set.of(NodeRole.PEON))) {
            binder.bind(ClusterTestingTaskConfig.class).toProvider(TestConfigProvider.class).in(LazySingleton.class);
            binder.bind(CoordinatorClient.class).to(FaultyCoordinatorClient.class).in(LazySingleton.class);
            binder.bind(RemoteTaskActionClientFactory.class).to(FaultyRemoteTaskActionClientFactory.class).in(LazySingleton.class);
        } else if (this.roles.contains(NodeRole.OVERLORD)) {
            binder.bind(GlobalTaskLockbox.class).to(FaultyTaskLockbox.class).in(LazySingleton.class);
        } else if (this.roles.contains(NodeRole.INDEXER)) {
            JsonConfigProvider.bind((Binder)binder, (String)PROPERTY_OVERLORD_CLIENT_CONFIG, ClusterTestingTaskConfig.OverlordClientConfig.class);
            binder.bind(OverlordClient.class).to(FaultyOverlordClient.class).in(LazySingleton.class);
            binder.bind(RemoteTaskActionClientFactory.class).to(FaultyRemoteTaskActionClientFactory.class).in(LazySingleton.class);
        }
    }

    public List<? extends Module> getJacksonModules() {
        return List.of(new SimpleModule(this.getClass().getSimpleName()).registerSubtypes(new NamedType[]{new NamedType(FaultyLagAggregator.class, "faulty")}));
    }

    private static class TestConfigProvider
    implements Provider<ClusterTestingTaskConfig> {
        private final Task task;
        private final ObjectMapper mapper;

        @Inject
        public TestConfigProvider(Task task, ObjectMapper mapper) {
            this.task = task;
            this.mapper = mapper;
        }

        public ClusterTestingTaskConfig get() {
            try {
                ClusterTestingTaskConfig testingConfig = ClusterTestingTaskConfig.forTask(this.task, this.mapper);
                log.warn("Running task in cluster testing mode with config[%s].", new Object[]{testingConfig});
                return testingConfig;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

