/*
 * Decompiled with CFR 0.152.
 */
package org.schemarepo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.schemarepo.SchemaEntry;
import org.schemarepo.SchemaValidationException;
import org.schemarepo.Validator;

public class ValidatorFactory {
    public static final String REJECT_VALIDATOR = "repo.reject";
    public static final ValidatorFactory EMPTY = new Builder().build();
    private final HashMap<String, Validator> validators;
    private final Set<String> defaultSubjectValidators;

    private ValidatorFactory(HashMap<String, Validator> validators, Set<String> defaultSubjectValidators) {
        this.validators = validators;
        this.defaultSubjectValidators = defaultSubjectValidators;
    }

    public final List<Validator> getValidators(Set<String> validatorNames) {
        ArrayList<Validator> result = new ArrayList<Validator>();
        for (String name : validatorNames) {
            Validator v = this.validators.get(name);
            if (v == null) continue;
            result.add(v);
        }
        return result;
    }

    public final Set<String> getDefaultSubjectValidators() {
        HashSet<String> result = new HashSet<String>(this.defaultSubjectValidators.size());
        for (String name : this.defaultSubjectValidators) {
            if (!this.validators.containsKey(name)) continue;
            result.add(name);
        }
        return result;
    }

    private static class Reject
    implements Validator {
        private Reject() {
        }

        @Override
        public void validate(String schemaToValidate, Iterable<SchemaEntry> schemasInOrder) throws SchemaValidationException {
            throw new SchemaValidationException("repo.validator.reject validator always rejects validation");
        }
    }

    public static class Builder {
        private final HashMap<String, Validator> validators = new HashMap();
        private final Set<String> defaultSubjectValidators;

        public Builder() {
            this.validators.put(ValidatorFactory.REJECT_VALIDATOR, new Reject());
            this.defaultSubjectValidators = new HashSet<String>();
        }

        public Builder setValidator(String name, Validator validator) {
            if (name.startsWith("repo.")) {
                throw new RuntimeException("Validator names starting with 'repo.' are reserved.  Attempted to set validator with name: " + name);
            }
            this.validators.put(name, validator);
            return this;
        }

        public Builder setDefaultValidator(String name) {
            this.defaultSubjectValidators.add(name);
            return this;
        }

        public Builder setDefaultValidators(Collection<String> validatorNames) {
            for (String name : validatorNames) {
                this.setDefaultValidator(name);
            }
            return this;
        }

        public ValidatorFactory build() {
            return new ValidatorFactory(new HashMap<String, Validator>(this.validators), new HashSet<String>(this.defaultSubjectValidators));
        }
    }
}

