// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

//go:build generate
// +build generate

package main

import (
	"fmt"
	"os"
	"os/exec"
	"strings"
)

func main() {
	commit, err := getGitCommit()
	if err != nil {
		fmt.Println("Error getting Git commit (not a git repo?):", err)
	}

	tag, err := getGitTag()
	if err != nil {
		fmt.Println("Error getting Git tag (not a git repo?):", err)
	}

	content := fmt.Sprintf("// Code generated by go generate; DO NOT EDIT.\n\npackage main\n\nvar (\n\tGitCommit = \"%s\"\n\tVersion = \"%s\"\n)\n", commit, tag)

	if err := os.WriteFile("version.go", []byte(content), 0644); err != nil {
		fmt.Println("Error writing version.go:", err)
		os.Exit(1)
	}
}

func getGitCommit() (string, error) {
	out, err := exec.Command("git", "rev-parse", "HEAD").Output()
	if err != nil {
		return "unknown", err
	}
	return strings.Split(string(out), "\n")[0], nil
}

func getGitTag() (string, error) {
	out, err := exec.Command("git", "describe", "--tags", "--abbrev=0").Output()
	if err != nil {
		return "unknown", err
	}
	return strings.Split(string(out), "\n")[0], nil
}
