/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.failover;

import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.repository.CommandDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowInstanceDao;
import org.apache.dolphinscheduler.extract.master.command.WorkflowFailoverCommandParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WorkflowFailover {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowFailover.class);
    @Autowired
    private WorkflowInstanceDao workflowInstanceDao;
    @Autowired
    private CommandDao commandDao;

    @Transactional
    public void failoverWorkflow(WorkflowInstance workflowInstance) {
        this.workflowInstanceDao.updateWorkflowInstanceState(workflowInstance.getId(), workflowInstance.getState(), WorkflowExecutionStatus.FAILOVER);
        WorkflowFailoverCommandParam failoverWorkflowCommandParam = WorkflowFailoverCommandParam.builder().workflowExecutionStatus(workflowInstance.getState()).build();
        Command failoverCommand = Command.builder().commandParam(JSONUtils.toJsonString((Object)failoverWorkflowCommandParam)).commandType(CommandType.RECOVER_TOLERANCE_FAULT_PROCESS).workflowDefinitionCode(workflowInstance.getWorkflowDefinitionCode().longValue()).workflowDefinitionVersion(workflowInstance.getWorkflowDefinitionVersion()).workflowInstanceId(workflowInstance.getId().intValue()).build();
        this.commandDao.insert((Object)failoverCommand);
        log.info("Success failover workflowInstance: [id={}, name={}, state={}]", new Object[]{workflowInstance.getId(), workflowInstance.getName(), workflowInstance.getState().name()});
    }
}

