/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.engine.workflow.trigger;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.WorkflowDefinition;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.utils.EnvironmentUtils;
import org.apache.dolphinscheduler.dao.utils.WorkerGroupUtils;
import org.apache.dolphinscheduler.extract.master.command.BackfillWorkflowCommandParam;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowBackfillTriggerRequest;
import org.apache.dolphinscheduler.extract.master.transportor.workflow.WorkflowBackfillTriggerResponse;
import org.apache.dolphinscheduler.server.master.engine.workflow.trigger.AbstractWorkflowTrigger;
import org.springframework.stereotype.Component;

@Component
public class WorkflowBackfillTrigger
extends AbstractWorkflowTrigger<WorkflowBackfillTriggerRequest, WorkflowBackfillTriggerResponse> {
    @Override
    protected ImmutablePair<WorkflowDefinition, WorkflowInstance> constructWorkflowInstance(WorkflowBackfillTriggerRequest backfillTriggerRequest) {
        CommandType commandType = CommandType.COMPLEMENT_DATA;
        Long workflowCode = backfillTriggerRequest.getWorkflowCode();
        Integer workflowVersion = backfillTriggerRequest.getWorkflowVersion();
        List backfillTimeList = backfillTriggerRequest.getBackfillTimeList();
        WorkflowDefinition workflowDefinition = this.getProcessDefinition(workflowCode, workflowVersion);
        WorkflowInstance workflowInstance = new WorkflowInstance();
        workflowInstance.setWorkflowDefinitionCode(Long.valueOf(workflowDefinition.getCode()));
        workflowInstance.setWorkflowDefinitionVersion(workflowDefinition.getVersion());
        workflowInstance.setProjectCode(Long.valueOf(workflowDefinition.getProjectCode()));
        workflowInstance.setCommandType(commandType);
        workflowInstance.setStateWithDesc(WorkflowExecutionStatus.SUBMITTED_SUCCESS, commandType.name());
        workflowInstance.setRecovery(Flag.NO);
        workflowInstance.setScheduleTime(DateUtils.stringToDate((String)((String)backfillTimeList.get(0))));
        workflowInstance.setStartTime(new Date());
        workflowInstance.setRestartTime(workflowInstance.getStartTime());
        workflowInstance.setRunTimes(1);
        workflowInstance.setName(String.join((CharSequence)"-", workflowDefinition.getName(), DateUtils.getCurrentTimeStamp()));
        workflowInstance.setTaskDependType(backfillTriggerRequest.getTaskDependType());
        workflowInstance.setFailureStrategy(backfillTriggerRequest.getFailureStrategy());
        workflowInstance.setWarningType((WarningType)ObjectUtils.defaultIfNull((Object)backfillTriggerRequest.getWarningType(), (Object)WarningType.NONE));
        workflowInstance.setWarningGroupId(backfillTriggerRequest.getWarningGroupId());
        workflowInstance.setExecutorId(backfillTriggerRequest.getUserId().intValue());
        workflowInstance.setExecutorName(this.getExecutorUser(backfillTriggerRequest.getUserId()).getUserName());
        workflowInstance.setTenantCode(backfillTriggerRequest.getTenantCode());
        workflowInstance.setIsSubWorkflow(Flag.NO);
        workflowInstance.addHistoryCmd(commandType);
        workflowInstance.setWorkflowInstancePriority(backfillTriggerRequest.getWorkflowInstancePriority());
        workflowInstance.setWorkerGroup(WorkerGroupUtils.getWorkerGroupOrDefault((String)backfillTriggerRequest.getWorkerGroup()));
        workflowInstance.setEnvironmentCode(EnvironmentUtils.getEnvironmentCodeOrDefault((Long)backfillTriggerRequest.getEnvironmentCode()));
        workflowInstance.setTimeout(workflowDefinition.getTimeout());
        workflowInstance.setDryRun(backfillTriggerRequest.getDryRun().getCode());
        return ImmutablePair.of((Object)workflowDefinition, (Object)workflowInstance);
    }

    @Override
    protected Command constructTriggerCommand(WorkflowBackfillTriggerRequest backfillTriggerRequest, WorkflowInstance workflowInstance) {
        BackfillWorkflowCommandParam backfillWorkflowCommandParam = ((BackfillWorkflowCommandParam.BackfillWorkflowCommandParamBuilder)((BackfillWorkflowCommandParam.BackfillWorkflowCommandParamBuilder)((BackfillWorkflowCommandParam.BackfillWorkflowCommandParamBuilder)BackfillWorkflowCommandParam.builder().commandParams(backfillTriggerRequest.getStartParamList())).startNodes(backfillTriggerRequest.getStartNodes())).timeZone(DateUtils.getTimezone())).backfillTimeList(backfillTriggerRequest.getBackfillTimeList()).build();
        return Command.builder().commandType(CommandType.COMPLEMENT_DATA).workflowDefinitionCode(backfillTriggerRequest.getWorkflowCode().longValue()).workflowDefinitionVersion(backfillTriggerRequest.getWorkflowVersion().intValue()).workflowInstanceId(workflowInstance.getId().intValue()).workflowInstancePriority(workflowInstance.getWorkflowInstancePriority()).commandParam(JSONUtils.toJsonString((Object)backfillWorkflowCommandParam)).build();
    }

    @Override
    protected WorkflowBackfillTriggerResponse onTriggerSuccess(WorkflowInstance workflowInstance) {
        return WorkflowBackfillTriggerResponse.success((Integer)workflowInstance.getId());
    }
}

