/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.VirtualNetworkRuleInner;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.models.SqlServer;
import com.azure.resourcemanager.sql.models.SqlVirtualNetworkRule;
import com.azure.resourcemanager.sql.models.SqlVirtualNetworkRuleOperations;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlVirtualNetworkRuleImpl
extends ExternalChildResourceImpl<SqlVirtualNetworkRule, VirtualNetworkRuleInner, SqlServerImpl, SqlServer>
implements SqlVirtualNetworkRule,
SqlVirtualNetworkRule.SqlVirtualNetworkRuleDefinition<SqlServer.DefinitionStages.WithCreate>,
SqlVirtualNetworkRule.Update,
SqlVirtualNetworkRuleOperations.SqlVirtualNetworkRuleOperationsDefinition {
    private SqlServerManager sqlServerManager;
    private String resourceGroupName;
    private String sqlServerName;

    SqlVirtualNetworkRuleImpl(String name, SqlServerImpl parent, VirtualNetworkRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, (Object)parent, (Object)innerObject);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = parent.resourceGroupName();
        this.sqlServerName = parent.name();
    }

    SqlVirtualNetworkRuleImpl(String resourceGroupName, String sqlServerName, String name, VirtualNetworkRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
    }

    SqlVirtualNetworkRuleImpl(String name, VirtualNetworkRuleInner innerObject, SqlServerManager sqlServerManager) {
        super(name, null, (Object)innerObject);
        Objects.requireNonNull(sqlServerManager);
        this.sqlServerManager = sqlServerManager;
    }

    public Mono<SqlVirtualNetworkRule> createResourceAsync() {
        SqlVirtualNetworkRuleImpl self = this;
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getVirtualNetworkRules().createOrUpdateAsync(this.resourceGroupName, this.sqlServerName, this.name(), (VirtualNetworkRuleInner)((Object)this.innerModel())).map(inner -> {
            self.setInner(inner);
            return self;
        });
    }

    public Mono<SqlVirtualNetworkRule> updateResourceAsync() {
        return this.createResourceAsync();
    }

    public Mono<Void> deleteResourceAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getVirtualNetworkRules().deleteAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    protected Mono<VirtualNetworkRuleInner> getInnerAsync() {
        return ((SqlManagementClient)this.sqlServerManager.serviceClient()).getVirtualNetworkRules().getAsync(this.resourceGroupName, this.sqlServerName, this.name());
    }

    public SqlVirtualNetworkRuleImpl update() {
        super.prepareUpdate();
        return this;
    }

    public String id() {
        return ((VirtualNetworkRuleInner)((Object)this.innerModel())).id();
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String sqlServerName() {
        return this.sqlServerName;
    }

    @Override
    public String subnetId() {
        return ((VirtualNetworkRuleInner)((Object)this.innerModel())).virtualNetworkSubnetId();
    }

    @Override
    public String state() {
        return ((VirtualNetworkRuleInner)((Object)this.innerModel())).state().toString();
    }

    @Override
    public String parentId() {
        return ResourceUtils.parentResourceIdFromResourceId((String)this.id());
    }

    @Override
    public void delete() {
        this.deleteResourceAsync().block();
    }

    @Override
    public Mono<Void> deleteAsync() {
        return this.deleteResourceAsync();
    }

    @Override
    public SqlVirtualNetworkRuleImpl withExistingSqlServer(String resourceGroupName, String sqlServerName) {
        this.resourceGroupName = resourceGroupName;
        this.sqlServerName = sqlServerName;
        return this;
    }

    @Override
    public SqlVirtualNetworkRuleImpl withExistingSqlServerId(String sqlServerId) {
        Objects.requireNonNull(sqlServerId);
        ResourceId resourceId = ResourceId.fromString((String)sqlServerId);
        this.resourceGroupName = resourceId.resourceGroupName();
        this.sqlServerName = resourceId.name();
        return this;
    }

    @Override
    public SqlVirtualNetworkRuleImpl withExistingSqlServer(SqlServer sqlServer) {
        this.resourceGroupName = sqlServer.resourceGroupName();
        this.sqlServerName = sqlServer.name();
        return this;
    }

    @Override
    public SqlVirtualNetworkRuleImpl withSubnet(String networkId, String subnetName) {
        ((VirtualNetworkRuleInner)((Object)this.innerModel())).withVirtualNetworkSubnetId(networkId + "/subnets/" + subnetName);
        ((VirtualNetworkRuleInner)((Object)this.innerModel())).withIgnoreMissingVnetServiceEndpoint(false);
        return this;
    }

    @Override
    public SqlVirtualNetworkRuleImpl ignoreMissingSqlServiceEndpoint() {
        ((VirtualNetworkRuleInner)((Object)this.innerModel())).withIgnoreMissingVnetServiceEndpoint(true);
        return this;
    }

    public SqlServer.DefinitionStages.WithCreate attach() {
        return (SqlServer.DefinitionStages.WithCreate)this.parent();
    }
}

