/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetUpdateProperties;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.AutomaticRepairsPolicy;
import com.azure.resourcemanager.compute.models.Plan;
import com.azure.resourcemanager.compute.models.ScaleInPolicy;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.UpdateResource;
import com.azure.resourcemanager.compute.models.UpgradePolicy;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetIdentity;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetUpdateVMProfile;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class VirtualMachineScaleSetUpdate
extends UpdateResource {
    @JsonProperty(value="sku")
    private Sku sku;
    @JsonProperty(value="plan")
    private Plan plan;
    @JsonProperty(value="properties")
    private VirtualMachineScaleSetUpdateProperties innerProperties;
    @JsonProperty(value="identity")
    private VirtualMachineScaleSetIdentity identity;

    public Sku sku() {
        return this.sku;
    }

    public VirtualMachineScaleSetUpdate withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Plan plan() {
        return this.plan;
    }

    public VirtualMachineScaleSetUpdate withPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    private VirtualMachineScaleSetUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public VirtualMachineScaleSetIdentity identity() {
        return this.identity;
    }

    public VirtualMachineScaleSetUpdate withIdentity(VirtualMachineScaleSetIdentity identity) {
        this.identity = identity;
        return this;
    }

    @Override
    public VirtualMachineScaleSetUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public UpgradePolicy upgradePolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().upgradePolicy();
    }

    public VirtualMachineScaleSetUpdate withUpgradePolicy(UpgradePolicy upgradePolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withUpgradePolicy(upgradePolicy);
        return this;
    }

    public AutomaticRepairsPolicy automaticRepairsPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().automaticRepairsPolicy();
    }

    public VirtualMachineScaleSetUpdate withAutomaticRepairsPolicy(AutomaticRepairsPolicy automaticRepairsPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withAutomaticRepairsPolicy(automaticRepairsPolicy);
        return this;
    }

    public VirtualMachineScaleSetUpdateVMProfile virtualMachineProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachineProfile();
    }

    public VirtualMachineScaleSetUpdate withVirtualMachineProfile(VirtualMachineScaleSetUpdateVMProfile virtualMachineProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withVirtualMachineProfile(virtualMachineProfile);
        return this;
    }

    public Boolean overprovision() {
        return this.innerProperties() == null ? null : this.innerProperties().overprovision();
    }

    public VirtualMachineScaleSetUpdate withOverprovision(Boolean overprovision) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withOverprovision(overprovision);
        return this;
    }

    public Boolean doNotRunExtensionsOnOverprovisionedVMs() {
        return this.innerProperties() == null ? null : this.innerProperties().doNotRunExtensionsOnOverprovisionedVMs();
    }

    public VirtualMachineScaleSetUpdate withDoNotRunExtensionsOnOverprovisionedVMs(Boolean doNotRunExtensionsOnOverprovisionedVMs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withDoNotRunExtensionsOnOverprovisionedVMs(doNotRunExtensionsOnOverprovisionedVMs);
        return this;
    }

    public Boolean singlePlacementGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().singlePlacementGroup();
    }

    public VirtualMachineScaleSetUpdate withSinglePlacementGroup(Boolean singlePlacementGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withSinglePlacementGroup(singlePlacementGroup);
        return this;
    }

    public AdditionalCapabilities additionalCapabilities() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalCapabilities();
    }

    public VirtualMachineScaleSetUpdate withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withAdditionalCapabilities(additionalCapabilities);
        return this;
    }

    public ScaleInPolicy scaleInPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().scaleInPolicy();
    }

    public VirtualMachineScaleSetUpdate withScaleInPolicy(ScaleInPolicy scaleInPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withScaleInPolicy(scaleInPolicy);
        return this;
    }

    public SubResource proximityPlacementGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().proximityPlacementGroup();
    }

    public VirtualMachineScaleSetUpdate withProximityPlacementGroup(SubResource proximityPlacementGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetUpdateProperties();
        }
        this.innerProperties().withProximityPlacementGroup(proximityPlacementGroup);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.plan() != null) {
            this.plan().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

