/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.labels;

import io.kubernetes.client.util.labels.LabelMatcher;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class LabelSelector
implements Predicate<Map<String, String>> {
    private LabelMatcher[] labelMatchers;

    LabelSelector(LabelMatcher ... matchers) {
        this.labelMatchers = matchers;
    }

    public static LabelSelector and(LabelMatcher ... matchers) {
        return new LabelSelector(matchers);
    }

    public static LabelSelector empty() {
        return LabelSelector.and(new LabelMatcher[0]);
    }

    @Override
    public boolean test(Map<String, String> labels) {
        return Arrays.stream(this.labelMatchers).allMatch(matcher -> matcher.test((String)labels.get(matcher.getKey())));
    }

    public String toString() {
        return Arrays.stream(this.labelMatchers).map(m -> m.toString()).collect(Collectors.joining(","));
    }
}

