/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.api.dto.ProductInfoDto;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.UiPluginService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.common.enums.PluginType;
import org.apache.dolphinscheduler.dao.entity.DsVersion;
import org.apache.dolphinscheduler.dao.entity.PluginDefine;
import org.apache.dolphinscheduler.dao.mapper.PluginDefineMapper;
import org.apache.dolphinscheduler.dao.repository.DsVersionDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UiPluginServiceImpl
extends BaseServiceImpl
implements UiPluginService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UiPluginServiceImpl.class);
    @Autowired
    PluginDefineMapper pluginDefineMapper;
    @Autowired
    private DsVersionDao dsVersionDao;
    private String dsVersion;

    @PostConstruct
    private void init() {
        this.dsVersion = this.dsVersionDao.selectVersion().map(DsVersion::getVersion).orElse("unknown");
    }

    @Override
    public Map<String, Object> queryUiPluginsByType(PluginType pluginType) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!pluginType.getHasUi()) {
            log.warn("Plugin does not have UI.");
            this.putMsg(result, Status.PLUGIN_NOT_A_UI_COMPONENT, new Object[0]);
            return result;
        }
        List pluginDefines = this.pluginDefineMapper.queryByPluginType(pluginType.getDesc());
        if (CollectionUtils.isEmpty((Collection)pluginDefines)) {
            log.warn("Query plugins result is null, check status of plugins.");
            this.putMsg(result, Status.QUERY_PLUGINS_RESULT_IS_NULL, new Object[0]);
            return result;
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", pluginDefines);
        return result;
    }

    @Override
    public Map<String, Object> queryUiPluginDetailById(int id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        PluginDefine pluginDefine = this.pluginDefineMapper.queryDetailById(id);
        if (null == pluginDefine) {
            log.warn("Query plugins result is empty, pluginId:{}.", (Object)id);
            this.putMsg(result, Status.QUERY_PLUGIN_DETAIL_RESULT_IS_NULL, new Object[0]);
            return result;
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", pluginDefine);
        return result;
    }

    @Override
    public ProductInfoDto queryProductInfo() {
        ProductInfoDto result = new ProductInfoDto();
        result.setVersion(this.dsVersion);
        return result;
    }
}

