/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.Architecture;
import com.azure.resourcemanager.compute.models.Disallowed;
import com.azure.resourcemanager.compute.models.GalleryImageFeature;
import com.azure.resourcemanager.compute.models.GalleryImageIdentifier;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.ImagePurchasePlan;
import com.azure.resourcemanager.compute.models.OperatingSystemStateTypes;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.RecommendedMachineConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class SharedGalleryImageProperties {
    @JsonProperty(value="osType", required=true)
    private OperatingSystemTypes osType;
    @JsonProperty(value="osState", required=true)
    private OperatingSystemStateTypes osState;
    @JsonProperty(value="endOfLifeDate")
    private OffsetDateTime endOfLifeDate;
    @JsonProperty(value="identifier", required=true)
    private GalleryImageIdentifier identifier;
    @JsonProperty(value="recommended")
    private RecommendedMachineConfiguration recommended;
    @JsonProperty(value="disallowed")
    private Disallowed disallowed;
    @JsonProperty(value="hyperVGeneration")
    private HyperVGeneration hyperVGeneration;
    @JsonProperty(value="features")
    private List<GalleryImageFeature> features;
    @JsonProperty(value="purchasePlan")
    private ImagePurchasePlan purchasePlan;
    @JsonProperty(value="architecture")
    private Architecture architecture;
    @JsonProperty(value="privacyStatementUri")
    private String privacyStatementUri;
    @JsonProperty(value="eula")
    private String eula;
    private static final ClientLogger LOGGER = new ClientLogger(SharedGalleryImageProperties.class);

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public SharedGalleryImageProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public OperatingSystemStateTypes osState() {
        return this.osState;
    }

    public SharedGalleryImageProperties withOsState(OperatingSystemStateTypes osState) {
        this.osState = osState;
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    public SharedGalleryImageProperties withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        this.endOfLifeDate = endOfLifeDate;
        return this;
    }

    public GalleryImageIdentifier identifier() {
        return this.identifier;
    }

    public SharedGalleryImageProperties withIdentifier(GalleryImageIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public RecommendedMachineConfiguration recommended() {
        return this.recommended;
    }

    public SharedGalleryImageProperties withRecommended(RecommendedMachineConfiguration recommended) {
        this.recommended = recommended;
        return this;
    }

    public Disallowed disallowed() {
        return this.disallowed;
    }

    public SharedGalleryImageProperties withDisallowed(Disallowed disallowed) {
        this.disallowed = disallowed;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public SharedGalleryImageProperties withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public List<GalleryImageFeature> features() {
        return this.features;
    }

    public SharedGalleryImageProperties withFeatures(List<GalleryImageFeature> features) {
        this.features = features;
        return this;
    }

    public ImagePurchasePlan purchasePlan() {
        return this.purchasePlan;
    }

    public SharedGalleryImageProperties withPurchasePlan(ImagePurchasePlan purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    public Architecture architecture() {
        return this.architecture;
    }

    public SharedGalleryImageProperties withArchitecture(Architecture architecture) {
        this.architecture = architecture;
        return this;
    }

    public String privacyStatementUri() {
        return this.privacyStatementUri;
    }

    public SharedGalleryImageProperties withPrivacyStatementUri(String privacyStatementUri) {
        this.privacyStatementUri = privacyStatementUri;
        return this;
    }

    public String eula() {
        return this.eula;
    }

    public SharedGalleryImageProperties withEula(String eula) {
        this.eula = eula;
        return this;
    }

    public void validate() {
        if (this.osType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property osType in model SharedGalleryImageProperties"));
        }
        if (this.osState() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property osState in model SharedGalleryImageProperties"));
        }
        if (this.identifier() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property identifier in model SharedGalleryImageProperties"));
        }
        this.identifier().validate();
        if (this.recommended() != null) {
            this.recommended().validate();
        }
        if (this.disallowed() != null) {
            this.disallowed().validate();
        }
        if (this.features() != null) {
            this.features().forEach(e -> e.validate());
        }
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
    }
}

