/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1APIService;
import io.kubernetes.client.openapi.models.V1APIServiceFluent;
import io.kubernetes.client.openapi.models.V1APIServiceSpec;
import io.kubernetes.client.openapi.models.V1APIServiceSpecBuilder;
import io.kubernetes.client.openapi.models.V1APIServiceSpecFluentImpl;
import io.kubernetes.client.openapi.models.V1APIServiceStatus;
import io.kubernetes.client.openapi.models.V1APIServiceStatusBuilder;
import io.kubernetes.client.openapi.models.V1APIServiceStatusFluentImpl;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluentImpl;
import java.util.Objects;

public class V1APIServiceFluentImpl<A extends V1APIServiceFluent<A>>
extends BaseFluent<A>
implements V1APIServiceFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1APIServiceSpecBuilder spec;
    private V1APIServiceStatusBuilder status;

    public V1APIServiceFluentImpl() {
    }

    public V1APIServiceFluentImpl(V1APIService instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String original) {
        return this.withApiVersion(new String(original));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String original) {
        return this.withKind(new String(original));
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1APIServiceFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1APIServiceFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1APIServiceFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1APIServiceFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1APIServiceFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public V1APIServiceSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public V1APIServiceSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(V1APIServiceSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new V1APIServiceSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public V1APIServiceFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public V1APIServiceFluent.SpecNested<A> withNewSpecLike(V1APIServiceSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public V1APIServiceFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public V1APIServiceFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new V1APIServiceSpecBuilder().build());
    }

    @Override
    public V1APIServiceFluent.SpecNested<A> editOrNewSpecLike(V1APIServiceSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public V1APIServiceStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public V1APIServiceStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(V1APIServiceStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new V1APIServiceStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public V1APIServiceFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public V1APIServiceFluent.StatusNested<A> withNewStatusLike(V1APIServiceStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public V1APIServiceFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public V1APIServiceFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new V1APIServiceStatusBuilder().build());
    }

    @Override
    public V1APIServiceFluent.StatusNested<A> editOrNewStatusLike(V1APIServiceStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIServiceFluentImpl that = (V1APIServiceFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends V1APIServiceStatusFluentImpl<V1APIServiceFluent.StatusNested<N>>
    implements V1APIServiceFluent.StatusNested<N>,
    Nested<N> {
        private final V1APIServiceStatusBuilder builder;

        StatusNestedImpl(V1APIServiceStatus item) {
            this.builder = new V1APIServiceStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new V1APIServiceStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1APIServiceFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends V1APIServiceSpecFluentImpl<V1APIServiceFluent.SpecNested<N>>
    implements V1APIServiceFluent.SpecNested<N>,
    Nested<N> {
        private final V1APIServiceSpecBuilder builder;

        SpecNestedImpl(V1APIServiceSpec item) {
            this.builder = new V1APIServiceSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new V1APIServiceSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1APIServiceFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1APIServiceFluent.MetadataNested<N>>
    implements V1APIServiceFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1APIServiceFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

