/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.utils.RoleAssignmentHelper;
import com.azure.resourcemanager.containerinstance.ContainerInstanceManager;
import com.azure.resourcemanager.containerinstance.fluent.models.ContainerGroupInner;
import com.azure.resourcemanager.containerinstance.implementation.ContainerGroupImpl;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupIdentity;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupIdentityUserAssignedIdentities;
import com.azure.resourcemanager.containerinstance.models.ResourceIdentityType;
import com.azure.resourcemanager.msi.models.Identity;
import com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class ContainerGroupMsiHandler
extends RoleAssignmentHelper {
    private final ContainerGroupImpl containerGroup;
    private final ClientLogger logger = new ClientLogger(((Object)((Object)this)).getClass());
    private List<String> creatableIdentityKeys;
    private Map<String, ContainerGroupIdentityUserAssignedIdentities> userAssignedIdentities;

    ContainerGroupMsiHandler(ContainerGroupImpl containerGroup) {
        super(((ContainerInstanceManager)containerGroup.manager()).authorizationManager(), containerGroup.taskGroup(), containerGroup.idProvider());
        this.containerGroup = containerGroup;
        this.creatableIdentityKeys = new ArrayList<String>();
        this.userAssignedIdentities = new HashMap<String, ContainerGroupIdentityUserAssignedIdentities>();
    }

    void processCreatedExternalIdentities() {
        for (String key : this.creatableIdentityKeys) {
            Identity identity = (Identity)this.containerGroup.taskGroup().taskResult(key);
            Objects.requireNonNull(identity);
            this.userAssignedIdentities.put(identity.id(), new ContainerGroupIdentityUserAssignedIdentities());
        }
        this.creatableIdentityKeys.clear();
    }

    void handleExternalIdentities() {
        if (!this.userAssignedIdentities.isEmpty()) {
            ((ContainerGroupInner)((Object)this.containerGroup.innerModel())).identity().withUserAssignedIdentities(this.userAssignedIdentities);
        }
    }

    ContainerGroupMsiHandler withLocalManagedServiceIdentity() {
        this.initContainerInstanceIdentity(ResourceIdentityType.SYSTEM_ASSIGNED);
        return this;
    }

    ContainerGroupMsiHandler withNewExternalManagedServiceIdentity(Creatable<Identity> creatableIdentity) {
        this.initContainerInstanceIdentity(ResourceIdentityType.USER_ASSIGNED);
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)creatableIdentity;
        Objects.requireNonNull(dependency);
        this.containerGroup.taskGroup().addDependency(dependency);
        this.creatableIdentityKeys.add(creatableIdentity.key());
        return this;
    }

    ContainerGroupMsiHandler withExistingExternalManagedServiceIdentity(Identity identity) {
        this.initContainerInstanceIdentity(ResourceIdentityType.USER_ASSIGNED);
        this.userAssignedIdentities.put(identity.id(), new ContainerGroupIdentityUserAssignedIdentities());
        return this;
    }

    private void initContainerInstanceIdentity(ResourceIdentityType identityType) {
        if (!identityType.equals((Object)ResourceIdentityType.USER_ASSIGNED) && !identityType.equals((Object)ResourceIdentityType.SYSTEM_ASSIGNED)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Invalid argument: " + (Object)((Object)identityType)));
        }
        ContainerGroupInner containerGroupInner = (ContainerGroupInner)((Object)this.containerGroup.innerModel());
        if (containerGroupInner.identity() == null) {
            containerGroupInner.withIdentity(new ContainerGroupIdentity());
        }
        if (containerGroupInner.identity().type() == null || containerGroupInner.identity().type().equals((Object)ResourceIdentityType.NONE) || containerGroupInner.identity().type().equals((Object)identityType)) {
            containerGroupInner.identity().withType(identityType);
        } else {
            containerGroupInner.identity().withType(ResourceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED);
        }
    }
}

