/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.CompressionType;
import com.amazonaws.services.sagemaker.model.TrainingInputMode;
import com.amazonaws.services.sagemaker.model.transform.ChannelSpecificationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ChannelSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String description;
    private Boolean isRequired;
    private List<String> supportedContentTypes;
    private List<String> supportedCompressionTypes;
    private List<String> supportedInputModes;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ChannelSpecification withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ChannelSpecification withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
    }

    public Boolean getIsRequired() {
        return this.isRequired;
    }

    public ChannelSpecification withIsRequired(Boolean isRequired) {
        this.setIsRequired(isRequired);
        return this;
    }

    public Boolean isRequired() {
        return this.isRequired;
    }

    public List<String> getSupportedContentTypes() {
        return this.supportedContentTypes;
    }

    public void setSupportedContentTypes(Collection<String> supportedContentTypes) {
        if (supportedContentTypes == null) {
            this.supportedContentTypes = null;
            return;
        }
        this.supportedContentTypes = new ArrayList<String>(supportedContentTypes);
    }

    public ChannelSpecification withSupportedContentTypes(String ... supportedContentTypes) {
        if (this.supportedContentTypes == null) {
            this.setSupportedContentTypes(new ArrayList<String>(supportedContentTypes.length));
        }
        for (String ele : supportedContentTypes) {
            this.supportedContentTypes.add(ele);
        }
        return this;
    }

    public ChannelSpecification withSupportedContentTypes(Collection<String> supportedContentTypes) {
        this.setSupportedContentTypes(supportedContentTypes);
        return this;
    }

    public List<String> getSupportedCompressionTypes() {
        return this.supportedCompressionTypes;
    }

    public void setSupportedCompressionTypes(Collection<String> supportedCompressionTypes) {
        if (supportedCompressionTypes == null) {
            this.supportedCompressionTypes = null;
            return;
        }
        this.supportedCompressionTypes = new ArrayList<String>(supportedCompressionTypes);
    }

    public ChannelSpecification withSupportedCompressionTypes(String ... supportedCompressionTypes) {
        if (this.supportedCompressionTypes == null) {
            this.setSupportedCompressionTypes(new ArrayList<String>(supportedCompressionTypes.length));
        }
        for (String ele : supportedCompressionTypes) {
            this.supportedCompressionTypes.add(ele);
        }
        return this;
    }

    public ChannelSpecification withSupportedCompressionTypes(Collection<String> supportedCompressionTypes) {
        this.setSupportedCompressionTypes(supportedCompressionTypes);
        return this;
    }

    public ChannelSpecification withSupportedCompressionTypes(CompressionType ... supportedCompressionTypes) {
        ArrayList<String> supportedCompressionTypesCopy = new ArrayList<String>(supportedCompressionTypes.length);
        for (CompressionType value : supportedCompressionTypes) {
            supportedCompressionTypesCopy.add(value.toString());
        }
        if (this.getSupportedCompressionTypes() == null) {
            this.setSupportedCompressionTypes(supportedCompressionTypesCopy);
        } else {
            this.getSupportedCompressionTypes().addAll(supportedCompressionTypesCopy);
        }
        return this;
    }

    public List<String> getSupportedInputModes() {
        return this.supportedInputModes;
    }

    public void setSupportedInputModes(Collection<String> supportedInputModes) {
        if (supportedInputModes == null) {
            this.supportedInputModes = null;
            return;
        }
        this.supportedInputModes = new ArrayList<String>(supportedInputModes);
    }

    public ChannelSpecification withSupportedInputModes(String ... supportedInputModes) {
        if (this.supportedInputModes == null) {
            this.setSupportedInputModes(new ArrayList<String>(supportedInputModes.length));
        }
        for (String ele : supportedInputModes) {
            this.supportedInputModes.add(ele);
        }
        return this;
    }

    public ChannelSpecification withSupportedInputModes(Collection<String> supportedInputModes) {
        this.setSupportedInputModes(supportedInputModes);
        return this;
    }

    public ChannelSpecification withSupportedInputModes(TrainingInputMode ... supportedInputModes) {
        ArrayList<String> supportedInputModesCopy = new ArrayList<String>(supportedInputModes.length);
        for (TrainingInputMode value : supportedInputModes) {
            supportedInputModesCopy.add(value.toString());
        }
        if (this.getSupportedInputModes() == null) {
            this.setSupportedInputModes(supportedInputModesCopy);
        } else {
            this.getSupportedInputModes().addAll(supportedInputModesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getIsRequired() != null) {
            sb.append("IsRequired: ").append(this.getIsRequired()).append(",");
        }
        if (this.getSupportedContentTypes() != null) {
            sb.append("SupportedContentTypes: ").append(this.getSupportedContentTypes()).append(",");
        }
        if (this.getSupportedCompressionTypes() != null) {
            sb.append("SupportedCompressionTypes: ").append(this.getSupportedCompressionTypes()).append(",");
        }
        if (this.getSupportedInputModes() != null) {
            sb.append("SupportedInputModes: ").append(this.getSupportedInputModes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelSpecification)) {
            return false;
        }
        ChannelSpecification other = (ChannelSpecification)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getIsRequired() == null ^ this.getIsRequired() == null) {
            return false;
        }
        if (other.getIsRequired() != null && !other.getIsRequired().equals(this.getIsRequired())) {
            return false;
        }
        if (other.getSupportedContentTypes() == null ^ this.getSupportedContentTypes() == null) {
            return false;
        }
        if (other.getSupportedContentTypes() != null && !other.getSupportedContentTypes().equals(this.getSupportedContentTypes())) {
            return false;
        }
        if (other.getSupportedCompressionTypes() == null ^ this.getSupportedCompressionTypes() == null) {
            return false;
        }
        if (other.getSupportedCompressionTypes() != null && !other.getSupportedCompressionTypes().equals(this.getSupportedCompressionTypes())) {
            return false;
        }
        if (other.getSupportedInputModes() == null ^ this.getSupportedInputModes() == null) {
            return false;
        }
        return other.getSupportedInputModes() == null || other.getSupportedInputModes().equals(this.getSupportedInputModes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getIsRequired() == null ? 0 : this.getIsRequired().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedContentTypes() == null ? 0 : this.getSupportedContentTypes().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedCompressionTypes() == null ? 0 : this.getSupportedCompressionTypes().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedInputModes() == null ? 0 : this.getSupportedInputModes().hashCode());
        return hashCode;
    }

    public ChannelSpecification clone() {
        try {
            return (ChannelSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ChannelSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

