/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

public enum BucketNameUtils {

    private static final int MIN_BUCKET_NAME_LENGTH = 1;

    public static void validateBucketName(String bucketName) throws IllegalArgumentException {
        if (bucketName == null) {
            throw new IllegalArgumentException("Bucket Name cannot be null");
        }
        String bucketNameNotContainAppid = bucketName;
        if (bucketName.contains("-") && bucketName.lastIndexOf("-") != 0) {
            bucketNameNotContainAppid = bucketName.substring(0, bucketName.lastIndexOf("-"));
        }
        if (bucketNameNotContainAppid.length() < 1) {
            throw new IllegalArgumentException("bucketName length must at least 1 character long");
        }
        for (int i = 0; i < bucketNameNotContainAppid.length(); ++i) {
            char next = bucketNameNotContainAppid.charAt(i);
            if (i == 0 && next == '-') {
                throw new IllegalArgumentException("Bucket name can not start with -");
            }
            if (next == '-' || next >= 'a' && next <= 'z' || next >= '0' && next <= '9') continue;
            if (next >= 'A' && next <= 'Z') {
                throw new IllegalArgumentException("Bucket name should not contain uppercase characters");
            }
            if (next == ' ' || next == '\t' || next == '\r' || next == '\n') {
                throw new IllegalArgumentException("Bucket name should not contain whitespace");
            }
            throw new IllegalArgumentException("Bucket name only should contain lowercase characters, num and -");
        }
    }
}

