/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.RetentionPolicy;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class LogProfileProperties {
    @JsonProperty(value="storageAccountId")
    private String storageAccountId;
    @JsonProperty(value="serviceBusRuleId")
    private String serviceBusRuleId;
    @JsonProperty(value="locations", required=true)
    private List<String> locations;
    @JsonProperty(value="categories", required=true)
    private List<String> categories;
    @JsonProperty(value="retentionPolicy", required=true)
    private RetentionPolicy retentionPolicy;
    private static final ClientLogger LOGGER = new ClientLogger(LogProfileProperties.class);

    public String storageAccountId() {
        return this.storageAccountId;
    }

    public LogProfileProperties withStorageAccountId(String storageAccountId) {
        this.storageAccountId = storageAccountId;
        return this;
    }

    public String serviceBusRuleId() {
        return this.serviceBusRuleId;
    }

    public LogProfileProperties withServiceBusRuleId(String serviceBusRuleId) {
        this.serviceBusRuleId = serviceBusRuleId;
        return this;
    }

    public List<String> locations() {
        return this.locations;
    }

    public LogProfileProperties withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    public List<String> categories() {
        return this.categories;
    }

    public LogProfileProperties withCategories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    public RetentionPolicy retentionPolicy() {
        return this.retentionPolicy;
    }

    public LogProfileProperties withRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public void validate() {
        if (this.locations() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property locations in model LogProfileProperties"));
        }
        if (this.categories() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property categories in model LogProfileProperties"));
        }
        if (this.retentionPolicy() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property retentionPolicy in model LogProfileProperties"));
        }
        this.retentionPolicy().validate();
    }
}

