/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.CustomImage;
import com.amazonaws.services.sagemaker.model.ResourceSpec;
import com.amazonaws.services.sagemaker.model.transform.KernelGatewayAppSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KernelGatewayAppSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private ResourceSpec defaultResourceSpec;
    private List<CustomImage> customImages;
    private List<String> lifecycleConfigArns;

    public void setDefaultResourceSpec(ResourceSpec defaultResourceSpec) {
        this.defaultResourceSpec = defaultResourceSpec;
    }

    public ResourceSpec getDefaultResourceSpec() {
        return this.defaultResourceSpec;
    }

    public KernelGatewayAppSettings withDefaultResourceSpec(ResourceSpec defaultResourceSpec) {
        this.setDefaultResourceSpec(defaultResourceSpec);
        return this;
    }

    public List<CustomImage> getCustomImages() {
        return this.customImages;
    }

    public void setCustomImages(Collection<CustomImage> customImages) {
        if (customImages == null) {
            this.customImages = null;
            return;
        }
        this.customImages = new ArrayList<CustomImage>(customImages);
    }

    public KernelGatewayAppSettings withCustomImages(CustomImage ... customImages) {
        if (this.customImages == null) {
            this.setCustomImages(new ArrayList<CustomImage>(customImages.length));
        }
        for (CustomImage ele : customImages) {
            this.customImages.add(ele);
        }
        return this;
    }

    public KernelGatewayAppSettings withCustomImages(Collection<CustomImage> customImages) {
        this.setCustomImages(customImages);
        return this;
    }

    public List<String> getLifecycleConfigArns() {
        return this.lifecycleConfigArns;
    }

    public void setLifecycleConfigArns(Collection<String> lifecycleConfigArns) {
        if (lifecycleConfigArns == null) {
            this.lifecycleConfigArns = null;
            return;
        }
        this.lifecycleConfigArns = new ArrayList<String>(lifecycleConfigArns);
    }

    public KernelGatewayAppSettings withLifecycleConfigArns(String ... lifecycleConfigArns) {
        if (this.lifecycleConfigArns == null) {
            this.setLifecycleConfigArns(new ArrayList<String>(lifecycleConfigArns.length));
        }
        for (String ele : lifecycleConfigArns) {
            this.lifecycleConfigArns.add(ele);
        }
        return this;
    }

    public KernelGatewayAppSettings withLifecycleConfigArns(Collection<String> lifecycleConfigArns) {
        this.setLifecycleConfigArns(lifecycleConfigArns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDefaultResourceSpec() != null) {
            sb.append("DefaultResourceSpec: ").append(this.getDefaultResourceSpec()).append(",");
        }
        if (this.getCustomImages() != null) {
            sb.append("CustomImages: ").append(this.getCustomImages()).append(",");
        }
        if (this.getLifecycleConfigArns() != null) {
            sb.append("LifecycleConfigArns: ").append(this.getLifecycleConfigArns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KernelGatewayAppSettings)) {
            return false;
        }
        KernelGatewayAppSettings other = (KernelGatewayAppSettings)obj;
        if (other.getDefaultResourceSpec() == null ^ this.getDefaultResourceSpec() == null) {
            return false;
        }
        if (other.getDefaultResourceSpec() != null && !other.getDefaultResourceSpec().equals(this.getDefaultResourceSpec())) {
            return false;
        }
        if (other.getCustomImages() == null ^ this.getCustomImages() == null) {
            return false;
        }
        if (other.getCustomImages() != null && !other.getCustomImages().equals(this.getCustomImages())) {
            return false;
        }
        if (other.getLifecycleConfigArns() == null ^ this.getLifecycleConfigArns() == null) {
            return false;
        }
        return other.getLifecycleConfigArns() == null || other.getLifecycleConfigArns().equals(this.getLifecycleConfigArns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDefaultResourceSpec() == null ? 0 : this.getDefaultResourceSpec().hashCode());
        hashCode = 31 * hashCode + (this.getCustomImages() == null ? 0 : this.getCustomImages().hashCode());
        hashCode = 31 * hashCode + (this.getLifecycleConfigArns() == null ? 0 : this.getLifecycleConfigArns().hashCode());
        return hashCode;
    }

    public KernelGatewayAppSettings clone() {
        try {
            return (KernelGatewayAppSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KernelGatewayAppSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

