/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.repository.impl;

import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.dao.entity.WorkFlowRelationDetail;
import org.apache.dolphinscheduler.dao.entity.WorkflowTaskLineage;
import org.apache.dolphinscheduler.dao.mapper.WorkflowTaskLineageMapper;
import org.apache.dolphinscheduler.dao.repository.BaseDao;
import org.apache.dolphinscheduler.dao.repository.WorkflowTaskLineageDao;
import org.springframework.stereotype.Repository;

@Repository
public class WorkflowTaskLineageDaoImpl
extends BaseDao<WorkflowTaskLineage, WorkflowTaskLineageMapper>
implements WorkflowTaskLineageDao {
    public WorkflowTaskLineageDaoImpl(@NonNull WorkflowTaskLineageMapper workflowTaskLineageMapper) {
        super(workflowTaskLineageMapper);
        if (workflowTaskLineageMapper == null) {
            throw new NullPointerException("workflowTaskLineageMapper is marked non-null but is null");
        }
    }

    @Override
    public int batchDeleteByWorkflowDefinitionCode(List<Long> workflowDefinitionCodes) {
        if (CollectionUtils.isEmpty(workflowDefinitionCodes)) {
            return 0;
        }
        return ((WorkflowTaskLineageMapper)this.mybatisMapper).batchDeleteByWorkflowDefinitionCode(workflowDefinitionCodes);
    }

    @Override
    public int batchInsert(List<WorkflowTaskLineage> workflowTaskLineages) {
        if (CollectionUtils.isEmpty(workflowTaskLineages)) {
            return 0;
        }
        return ((WorkflowTaskLineageMapper)this.mybatisMapper).batchInsert(workflowTaskLineages);
    }

    @Override
    public List<WorkflowTaskLineage> queryByProjectCode(long projectCode) {
        return ((WorkflowTaskLineageMapper)this.mybatisMapper).queryByProjectCode(projectCode);
    }

    @Override
    public List<WorkFlowRelationDetail> queryWorkFlowLineageByCode(long workflowDefinitionCode) {
        return ((WorkflowTaskLineageMapper)this.mybatisMapper).queryWorkFlowLineageByCode(workflowDefinitionCode);
    }

    @Override
    public List<WorkFlowRelationDetail> queryWorkFlowLineageByName(long projectCode, String workflowDefinitionName) {
        return ((WorkflowTaskLineageMapper)this.mybatisMapper).queryWorkFlowLineageByName(projectCode, workflowDefinitionName);
    }

    @Override
    public List<WorkflowTaskLineage> queryWorkFlowLineageByDept(long deptProjectCode, long deptWorkflowDefinitionCode, long deptTaskDefinitionCode) {
        return ((WorkflowTaskLineageMapper)this.mybatisMapper).queryWorkFlowLineageByDept(deptProjectCode, deptWorkflowDefinitionCode, deptTaskDefinitionCode);
    }

    @Override
    public List<WorkflowTaskLineage> queryByWorkflowDefinitionCode(long workflowDefinitionCode) {
        return ((WorkflowTaskLineageMapper)this.mybatisMapper).queryByWorkflowDefinitionCode(workflowDefinitionCode);
    }

    @Override
    public int updateWorkflowTaskLineage(List<WorkflowTaskLineage> workflowTaskLineages) {
        if (CollectionUtils.isEmpty(workflowTaskLineages)) {
            return 0;
        }
        this.batchDeleteByWorkflowDefinitionCode(workflowTaskLineages.stream().map(WorkflowTaskLineage::getWorkflowDefinitionCode).distinct().collect(Collectors.toList()));
        return ((WorkflowTaskLineageMapper)this.mybatisMapper).batchInsert(workflowTaskLineages);
    }
}

