/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.databasemigrationservice.model.CollectorShortInfoResponse;
import com.amazonaws.services.databasemigrationservice.model.DatabaseInstanceSoftwareDetailsResponse;
import com.amazonaws.services.databasemigrationservice.model.ServerShortInfoResponse;
import com.amazonaws.services.databasemigrationservice.model.transform.DatabaseResponseMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DatabaseResponse
implements Serializable,
Cloneable,
StructuredPojo {
    private String databaseId;
    private String databaseName;
    private String ipAddress;
    private Long numberOfSchemas;
    private ServerShortInfoResponse server;
    private DatabaseInstanceSoftwareDetailsResponse softwareDetails;
    private List<CollectorShortInfoResponse> collectors;

    public void setDatabaseId(String databaseId) {
        this.databaseId = databaseId;
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public DatabaseResponse withDatabaseId(String databaseId) {
        this.setDatabaseId(databaseId);
        return this;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DatabaseResponse withDatabaseName(String databaseName) {
        this.setDatabaseName(databaseName);
        return this;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public DatabaseResponse withIpAddress(String ipAddress) {
        this.setIpAddress(ipAddress);
        return this;
    }

    public void setNumberOfSchemas(Long numberOfSchemas) {
        this.numberOfSchemas = numberOfSchemas;
    }

    public Long getNumberOfSchemas() {
        return this.numberOfSchemas;
    }

    public DatabaseResponse withNumberOfSchemas(Long numberOfSchemas) {
        this.setNumberOfSchemas(numberOfSchemas);
        return this;
    }

    public void setServer(ServerShortInfoResponse server) {
        this.server = server;
    }

    public ServerShortInfoResponse getServer() {
        return this.server;
    }

    public DatabaseResponse withServer(ServerShortInfoResponse server) {
        this.setServer(server);
        return this;
    }

    public void setSoftwareDetails(DatabaseInstanceSoftwareDetailsResponse softwareDetails) {
        this.softwareDetails = softwareDetails;
    }

    public DatabaseInstanceSoftwareDetailsResponse getSoftwareDetails() {
        return this.softwareDetails;
    }

    public DatabaseResponse withSoftwareDetails(DatabaseInstanceSoftwareDetailsResponse softwareDetails) {
        this.setSoftwareDetails(softwareDetails);
        return this;
    }

    public List<CollectorShortInfoResponse> getCollectors() {
        return this.collectors;
    }

    public void setCollectors(Collection<CollectorShortInfoResponse> collectors) {
        if (collectors == null) {
            this.collectors = null;
            return;
        }
        this.collectors = new ArrayList<CollectorShortInfoResponse>(collectors);
    }

    public DatabaseResponse withCollectors(CollectorShortInfoResponse ... collectors) {
        if (this.collectors == null) {
            this.setCollectors(new ArrayList<CollectorShortInfoResponse>(collectors.length));
        }
        for (CollectorShortInfoResponse ele : collectors) {
            this.collectors.add(ele);
        }
        return this;
    }

    public DatabaseResponse withCollectors(Collection<CollectorShortInfoResponse> collectors) {
        this.setCollectors(collectors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDatabaseId() != null) {
            sb.append("DatabaseId: ").append(this.getDatabaseId()).append(",");
        }
        if (this.getDatabaseName() != null) {
            sb.append("DatabaseName: ").append(this.getDatabaseName()).append(",");
        }
        if (this.getIpAddress() != null) {
            sb.append("IpAddress: ").append(this.getIpAddress()).append(",");
        }
        if (this.getNumberOfSchemas() != null) {
            sb.append("NumberOfSchemas: ").append(this.getNumberOfSchemas()).append(",");
        }
        if (this.getServer() != null) {
            sb.append("Server: ").append(this.getServer()).append(",");
        }
        if (this.getSoftwareDetails() != null) {
            sb.append("SoftwareDetails: ").append(this.getSoftwareDetails()).append(",");
        }
        if (this.getCollectors() != null) {
            sb.append("Collectors: ").append(this.getCollectors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseResponse)) {
            return false;
        }
        DatabaseResponse other = (DatabaseResponse)obj;
        if (other.getDatabaseId() == null ^ this.getDatabaseId() == null) {
            return false;
        }
        if (other.getDatabaseId() != null && !other.getDatabaseId().equals(this.getDatabaseId())) {
            return false;
        }
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null) {
            return false;
        }
        if (other.getDatabaseName() != null && !other.getDatabaseName().equals(this.getDatabaseName())) {
            return false;
        }
        if (other.getIpAddress() == null ^ this.getIpAddress() == null) {
            return false;
        }
        if (other.getIpAddress() != null && !other.getIpAddress().equals(this.getIpAddress())) {
            return false;
        }
        if (other.getNumberOfSchemas() == null ^ this.getNumberOfSchemas() == null) {
            return false;
        }
        if (other.getNumberOfSchemas() != null && !other.getNumberOfSchemas().equals(this.getNumberOfSchemas())) {
            return false;
        }
        if (other.getServer() == null ^ this.getServer() == null) {
            return false;
        }
        if (other.getServer() != null && !other.getServer().equals(this.getServer())) {
            return false;
        }
        if (other.getSoftwareDetails() == null ^ this.getSoftwareDetails() == null) {
            return false;
        }
        if (other.getSoftwareDetails() != null && !other.getSoftwareDetails().equals(this.getSoftwareDetails())) {
            return false;
        }
        if (other.getCollectors() == null ^ this.getCollectors() == null) {
            return false;
        }
        return other.getCollectors() == null || other.getCollectors().equals(this.getCollectors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDatabaseId() == null ? 0 : this.getDatabaseId().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseName() == null ? 0 : this.getDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.getIpAddress() == null ? 0 : this.getIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfSchemas() == null ? 0 : this.getNumberOfSchemas().hashCode());
        hashCode = 31 * hashCode + (this.getServer() == null ? 0 : this.getServer().hashCode());
        hashCode = 31 * hashCode + (this.getSoftwareDetails() == null ? 0 : this.getSoftwareDetails().hashCode());
        hashCode = 31 * hashCode + (this.getCollectors() == null ? 0 : this.getCollectors().hashCode());
        return hashCode;
    }

    public DatabaseResponse clone() {
        try {
            return (DatabaseResponse)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DatabaseResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

