/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.ActionSource;
import com.amazonaws.services.sagemaker.model.ActionStatus;
import com.amazonaws.services.sagemaker.model.MetadataProperties;
import com.amazonaws.services.sagemaker.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateActionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String actionName;
    private ActionSource source;
    private String actionType;
    private String description;
    private String status;
    private Map<String, String> properties;
    private MetadataProperties metadataProperties;
    private List<Tag> tags;

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public CreateActionRequest withActionName(String actionName) {
        this.setActionName(actionName);
        return this;
    }

    public void setSource(ActionSource source) {
        this.source = source;
    }

    public ActionSource getSource() {
        return this.source;
    }

    public CreateActionRequest withSource(ActionSource source) {
        this.setSource(source);
        return this;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public String getActionType() {
        return this.actionType;
    }

    public CreateActionRequest withActionType(String actionType) {
        this.setActionType(actionType);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateActionRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public CreateActionRequest withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public CreateActionRequest withStatus(ActionStatus status) {
        this.status = status.toString();
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public CreateActionRequest withProperties(Map<String, String> properties) {
        this.setProperties(properties);
        return this;
    }

    public CreateActionRequest addPropertiesEntry(String key, String value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put(key, value);
        return this;
    }

    public CreateActionRequest clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public void setMetadataProperties(MetadataProperties metadataProperties) {
        this.metadataProperties = metadataProperties;
    }

    public MetadataProperties getMetadataProperties() {
        return this.metadataProperties;
    }

    public CreateActionRequest withMetadataProperties(MetadataProperties metadataProperties) {
        this.setMetadataProperties(metadataProperties);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateActionRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateActionRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActionName() != null) {
            sb.append("ActionName: ").append(this.getActionName()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getActionType() != null) {
            sb.append("ActionType: ").append(this.getActionType()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties()).append(",");
        }
        if (this.getMetadataProperties() != null) {
            sb.append("MetadataProperties: ").append(this.getMetadataProperties()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateActionRequest)) {
            return false;
        }
        CreateActionRequest other = (CreateActionRequest)obj;
        if (other.getActionName() == null ^ this.getActionName() == null) {
            return false;
        }
        if (other.getActionName() != null && !other.getActionName().equals(this.getActionName())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getActionType() == null ^ this.getActionType() == null) {
            return false;
        }
        if (other.getActionType() != null && !other.getActionType().equals(this.getActionType())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !other.getProperties().equals(this.getProperties())) {
            return false;
        }
        if (other.getMetadataProperties() == null ^ this.getMetadataProperties() == null) {
            return false;
        }
        if (other.getMetadataProperties() != null && !other.getMetadataProperties().equals(this.getMetadataProperties())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActionName() == null ? 0 : this.getActionName().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getActionType() == null ? 0 : this.getActionType().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        hashCode = 31 * hashCode + (this.getMetadataProperties() == null ? 0 : this.getMetadataProperties().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateActionRequest clone() {
        return (CreateActionRequest)super.clone();
    }
}

