/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import io.kubernetes.client.openapi.models.V1StatefulSetSpec;
import io.kubernetes.client.openapi.models.V1StatefulSetSpecFluent;
import io.kubernetes.client.openapi.models.V1StatefulSetSpecFluentImpl;
import java.util.Objects;

public class V1StatefulSetSpecBuilder
extends V1StatefulSetSpecFluentImpl<V1StatefulSetSpecBuilder>
implements VisitableBuilder<V1StatefulSetSpec, V1StatefulSetSpecBuilder> {
    V1StatefulSetSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1StatefulSetSpecBuilder() {
        this(true);
    }

    public V1StatefulSetSpecBuilder(Boolean validationEnabled) {
        this(new V1StatefulSetSpec(), validationEnabled);
    }

    public V1StatefulSetSpecBuilder(V1StatefulSetSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public V1StatefulSetSpecBuilder(V1StatefulSetSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new V1StatefulSetSpec(), validationEnabled);
    }

    public V1StatefulSetSpecBuilder(V1StatefulSetSpecFluent<?> fluent, V1StatefulSetSpec instance) {
        this(fluent, instance, true);
    }

    public V1StatefulSetSpecBuilder(V1StatefulSetSpecFluent<?> fluent, V1StatefulSetSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPodManagementPolicy(instance.getPodManagementPolicy());
        fluent.withReplicas(instance.getReplicas());
        fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        fluent.withSelector(instance.getSelector());
        fluent.withServiceName(instance.getServiceName());
        fluent.withTemplate(instance.getTemplate());
        fluent.withUpdateStrategy(instance.getUpdateStrategy());
        fluent.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
        this.validationEnabled = validationEnabled;
    }

    public V1StatefulSetSpecBuilder(V1StatefulSetSpec instance) {
        this(instance, (Boolean)true);
    }

    public V1StatefulSetSpecBuilder(V1StatefulSetSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPodManagementPolicy(instance.getPodManagementPolicy());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withServiceName(instance.getServiceName());
        this.withTemplate(instance.getTemplate());
        this.withUpdateStrategy(instance.getUpdateStrategy());
        this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public V1StatefulSetSpec build() {
        V1StatefulSetSpec buildable = new V1StatefulSetSpec();
        buildable.setPodManagementPolicy(this.fluent.getPodManagementPolicy());
        buildable.setReplicas(this.fluent.getReplicas());
        buildable.setRevisionHistoryLimit(this.fluent.getRevisionHistoryLimit());
        buildable.setSelector(this.fluent.getSelector());
        buildable.setServiceName(this.fluent.getServiceName());
        buildable.setTemplate(this.fluent.getTemplate());
        buildable.setUpdateStrategy(this.fluent.getUpdateStrategy());
        buildable.setVolumeClaimTemplates(this.fluent.getVolumeClaimTemplates());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1StatefulSetSpecBuilder that = (V1StatefulSetSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

