/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.AadCredentialBuilderBase;
import com.azure.identity.TokenCachePersistenceOptions;
import com.azure.identity.UsernamePasswordCredential;
import com.azure.identity.implementation.util.IdentityUtil;
import com.azure.identity.implementation.util.ValidationUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UsernamePasswordCredentialBuilder
extends AadCredentialBuilderBase<UsernamePasswordCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(UsernamePasswordCredentialBuilder.class);
    private String username;
    private String password;

    public UsernamePasswordCredentialBuilder username(String username) {
        this.username = username;
        return this;
    }

    public UsernamePasswordCredentialBuilder password(String password) {
        this.password = password;
        return this;
    }

    public UsernamePasswordCredentialBuilder tokenCachePersistenceOptions(TokenCachePersistenceOptions tokenCachePersistenceOptions) {
        this.identityClientOptions.setTokenCacheOptions(tokenCachePersistenceOptions);
        return this;
    }

    UsernamePasswordCredentialBuilder allowUnencryptedCache() {
        this.identityClientOptions.setAllowUnencryptedCache(true);
        return this;
    }

    UsernamePasswordCredentialBuilder enablePersistentCache() {
        this.identityClientOptions.enablePersistentCache();
        return this;
    }

    @Override
    public UsernamePasswordCredentialBuilder additionallyAllowedTenants(String ... additionallyAllowedTenants) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(Arrays.asList(additionallyAllowedTenants)));
        return this;
    }

    @Override
    public UsernamePasswordCredentialBuilder additionallyAllowedTenants(List<String> additionallyAllowedTenants) {
        this.identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.resolveAdditionalTenants(additionallyAllowedTenants));
        return this;
    }

    public UsernamePasswordCredential build() {
        ValidationUtil.validate(this.getClass().getSimpleName(), (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("clientId", UsernamePasswordCredentialBuilder.this.clientId);
                this.put("username", UsernamePasswordCredentialBuilder.this.username);
                this.put("password", UsernamePasswordCredentialBuilder.this.password);
            }
        }, LOGGER);
        return new UsernamePasswordCredential(this.clientId, this.tenantId, this.username, this.password, this.identityClientOptions);
    }
}

