/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement;

import java.util.Objects;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;

public class IfElseStatement
implements Statement {
    private final Expression condition;
    private final Statement ifStatement;
    private Statement elseStatement;
    private boolean usingSemicolonForIfStatement = false;
    private boolean usingSemicolonForElseStatement = false;

    public IfElseStatement(Expression condition, Statement ifStatement) {
        this.condition = Objects.requireNonNull(condition, "The CONDITION of the IfElseStatement must not be null.");
        this.ifStatement = Objects.requireNonNull(ifStatement, "The IF Statement of the IfElseStatement must not be null.");
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Statement getIfStatement() {
        return this.ifStatement;
    }

    public void setElseStatement(Statement elseStatement) {
        this.elseStatement = elseStatement;
    }

    public Statement getElseStatement() {
        return this.elseStatement;
    }

    public void setUsingSemicolonForElseStatement(boolean usingSemicolonForElseStatement) {
        this.usingSemicolonForElseStatement = usingSemicolonForElseStatement;
    }

    public boolean isUsingSemicolonForElseStatement() {
        return this.usingSemicolonForElseStatement;
    }

    public void setUsingSemicolonForIfStatement(boolean usingSemicolonForIfStatement) {
        this.usingSemicolonForIfStatement = usingSemicolonForIfStatement;
    }

    public boolean isUsingSemicolonForIfStatement() {
        return this.usingSemicolonForIfStatement;
    }

    public StringBuilder appendTo(StringBuilder builder) {
        builder.append("IF ").append(this.condition).append(" ").append(this.ifStatement).append(this.usingSemicolonForIfStatement ? ";" : "");
        if (this.elseStatement != null) {
            builder.append(" ELSE ").append(this.elseStatement).append(this.usingSemicolonForElseStatement ? ";" : "");
        }
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }
}

