/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.jdbc.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.dolphinscheduler.plugin.registry.jdbc.JdbcRegistryProperties;
import org.apache.dolphinscheduler.plugin.registry.jdbc.JdbcRegistryThreadFactory;
import org.apache.dolphinscheduler.plugin.registry.jdbc.KeyUtils;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.DataType;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.JdbcRegistryDataChangeEventDTO;
import org.apache.dolphinscheduler.plugin.registry.jdbc.model.DTO.JdbcRegistryDataDTO;
import org.apache.dolphinscheduler.plugin.registry.jdbc.repository.JdbcRegistryDataChangeEventRepository;
import org.apache.dolphinscheduler.plugin.registry.jdbc.repository.JdbcRegistryDataRepository;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.IJdbcRegistryDataManager;
import org.apache.dolphinscheduler.plugin.registry.jdbc.server.IRegistryRowChangeNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionTemplate;

public class JdbcRegistryDataManager
implements IRegistryRowChangeNotifier<JdbcRegistryDataDTO>,
IJdbcRegistryDataManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcRegistryDataManager.class);
    private final Integer keepJdbcRegistryDataChangeEventHours = 2;
    private final JdbcRegistryProperties registryProperties;
    private final JdbcRegistryDataRepository jdbcRegistryDataRepository;
    private final JdbcRegistryDataChangeEventRepository jdbcRegistryDataChangeEventRepository;
    private final TransactionTemplate jdbcRegistryTransactionTemplate;
    private final List<IRegistryRowChangeNotifier.RegistryRowChangeListener<JdbcRegistryDataDTO>> registryRowChangeListeners;
    private long lastDetectedJdbcRegistryDataChangeEventId = -1L;

    public JdbcRegistryDataManager(JdbcRegistryProperties registryProperties, JdbcRegistryDataRepository jdbcRegistryDataRepository, JdbcRegistryDataChangeEventRepository jdbcRegistryDataChangeEventRepository, TransactionTemplate jdbcRegistryTransactionTemplate) {
        this.registryProperties = registryProperties;
        this.jdbcRegistryDataChangeEventRepository = jdbcRegistryDataChangeEventRepository;
        this.jdbcRegistryDataRepository = jdbcRegistryDataRepository;
        this.jdbcRegistryTransactionTemplate = jdbcRegistryTransactionTemplate;
        this.registryRowChangeListeners = new CopyOnWriteArrayList<IRegistryRowChangeNotifier.RegistryRowChangeListener<JdbcRegistryDataDTO>>();
    }

    @Override
    public void start() {
        this.lastDetectedJdbcRegistryDataChangeEventId = this.jdbcRegistryDataChangeEventRepository.getMaxJdbcRegistryDataChangeEventId();
        JdbcRegistryThreadFactory.getDefaultSchedulerThreadExecutor().scheduleWithFixedDelay(this::detectJdbcRegistryDataChangeEvent, this.registryProperties.getHeartbeatRefreshInterval().toMillis(), this.registryProperties.getHeartbeatRefreshInterval().toMillis(), TimeUnit.MILLISECONDS);
        JdbcRegistryThreadFactory.getDefaultSchedulerThreadExecutor().scheduleWithFixedDelay(this::purgeHistoryJdbcRegistryDataChangeEvent, 0L, Duration.ofHours(this.keepJdbcRegistryDataChangeEventHours.intValue()).toHours(), TimeUnit.HOURS);
    }

    private void detectJdbcRegistryDataChangeEvent() {
        List<JdbcRegistryDataChangeEventDTO> jdbcRegistryDataChangeEvents = this.jdbcRegistryDataChangeEventRepository.selectJdbcRegistryDataChangeEventWhereIdAfter(this.lastDetectedJdbcRegistryDataChangeEventId);
        if (CollectionUtils.isEmpty(jdbcRegistryDataChangeEvents)) {
            return;
        }
        for (JdbcRegistryDataChangeEventDTO jdbcRegistryDataChangeEvent : jdbcRegistryDataChangeEvents) {
            log.debug("Detect JdbcRegistryDataChangeEvent: {}", (Object)jdbcRegistryDataChangeEvent);
            switch (jdbcRegistryDataChangeEvent.getEventType()) {
                case ADD: {
                    this.doTriggerJdbcRegistryDataAddedListener(Lists.newArrayList((Object[])new JdbcRegistryDataDTO[]{jdbcRegistryDataChangeEvent.getJdbcRegistryData()}));
                    break;
                }
                case UPDATE: {
                    this.doTriggerJdbcRegistryDataUpdatedListener(Lists.newArrayList((Object[])new JdbcRegistryDataDTO[]{jdbcRegistryDataChangeEvent.getJdbcRegistryData()}));
                    break;
                }
                case DELETE: {
                    this.doTriggerJdbcRegistryDataRemovedListener(Lists.newArrayList((Object[])new JdbcRegistryDataDTO[]{jdbcRegistryDataChangeEvent.getJdbcRegistryData()}));
                    break;
                }
                default: {
                    log.error("Unknown event type: {}", (Object)jdbcRegistryDataChangeEvent.getEventType());
                }
            }
            if (jdbcRegistryDataChangeEvent.getId() <= this.lastDetectedJdbcRegistryDataChangeEventId) continue;
            this.lastDetectedJdbcRegistryDataChangeEventId = jdbcRegistryDataChangeEvent.getId();
        }
    }

    private void purgeHistoryJdbcRegistryDataChangeEvent() {
        log.info("Purge JdbcRegistryDataChangeEvent which createTime is before: {} hours", (Object)this.keepJdbcRegistryDataChangeEventHours);
        this.jdbcRegistryDataChangeEventRepository.deleteJdbcRegistryDataChangeEventBeforeCreateTime(DateUtils.addHours((Date)new Date(), (int)(-this.keepJdbcRegistryDataChangeEventHours.intValue())));
    }

    @Override
    public void subscribeRegistryRowChange(IRegistryRowChangeNotifier.RegistryRowChangeListener<JdbcRegistryDataDTO> registryRowChangeListener) {
        this.registryRowChangeListeners.add((IRegistryRowChangeNotifier.RegistryRowChangeListener<JdbcRegistryDataDTO>)Preconditions.checkNotNull(registryRowChangeListener));
    }

    @Override
    public boolean existKey(String key) {
        Preconditions.checkNotNull((Object)key);
        return this.jdbcRegistryDataRepository.selectByKey(key).isPresent();
    }

    @Override
    public List<JdbcRegistryDataDTO> getAllJdbcRegistryData() {
        return this.jdbcRegistryDataRepository.selectAll();
    }

    @Override
    public Optional<JdbcRegistryDataDTO> getRegistryDataByKey(String key) {
        Preconditions.checkNotNull((Object)key);
        return this.jdbcRegistryDataRepository.selectByKey(key);
    }

    @Override
    public List<JdbcRegistryDataDTO> listJdbcRegistryDataChildren(String key) {
        Preconditions.checkNotNull((Object)key);
        return this.jdbcRegistryDataRepository.selectAll().stream().filter(jdbcRegistryDataDTO -> KeyUtils.isParent(key, jdbcRegistryDataDTO.getDataKey())).collect(Collectors.toList());
    }

    @Override
    public void putJdbcRegistryData(Long clientId, String key, String value, DataType dataType) {
        Preconditions.checkNotNull((Object)clientId);
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)((Object)dataType));
        Optional<JdbcRegistryDataDTO> jdbcRegistryDataOptional = this.jdbcRegistryDataRepository.selectByKey(key);
        this.jdbcRegistryTransactionTemplate.execute(status -> {
            if (jdbcRegistryDataOptional.isPresent()) {
                JdbcRegistryDataDTO jdbcRegistryData = (JdbcRegistryDataDTO)jdbcRegistryDataOptional.get();
                if (!dataType.name().equals(jdbcRegistryData.getDataType())) {
                    throw new UnsupportedOperationException("The data type: " + jdbcRegistryData.getDataType() + " of the key: " + key + " cannot be updated");
                }
                if (DataType.EPHEMERAL.name().equals(jdbcRegistryData.getDataType()) && !jdbcRegistryData.getClientId().equals(clientId)) {
                    throw new UnsupportedOperationException("The EPHEMERAL data: " + key + " can only be updated by its owner: " + jdbcRegistryData.getClientId() + " but not: " + clientId);
                }
                jdbcRegistryData.setDataValue(value);
                jdbcRegistryData.setLastUpdateTime(new Date());
                this.jdbcRegistryDataRepository.updateById(jdbcRegistryData);
                JdbcRegistryDataChangeEventDTO jdbcRegistryDataChangeEvent = JdbcRegistryDataChangeEventDTO.builder().jdbcRegistryData(jdbcRegistryData).eventType(JdbcRegistryDataChangeEventDTO.EventType.UPDATE).createTime(new Date()).build();
                this.jdbcRegistryDataChangeEventRepository.insert(jdbcRegistryDataChangeEvent);
            } else {
                JdbcRegistryDataDTO jdbcRegistryDataDTO = JdbcRegistryDataDTO.builder().clientId(clientId).dataKey(key).dataValue(value).dataType(dataType.name()).createTime(new Date()).lastUpdateTime(new Date()).build();
                this.jdbcRegistryDataRepository.insert(jdbcRegistryDataDTO);
                JdbcRegistryDataChangeEventDTO registryDataChangeEvent = JdbcRegistryDataChangeEventDTO.builder().jdbcRegistryData(jdbcRegistryDataDTO).eventType(JdbcRegistryDataChangeEventDTO.EventType.ADD).createTime(new Date()).build();
                this.jdbcRegistryDataChangeEventRepository.insert(registryDataChangeEvent);
            }
            return null;
        });
    }

    @Override
    public void deleteJdbcRegistryDataByKey(String key) {
        Preconditions.checkNotNull((Object)key);
        Optional<JdbcRegistryDataDTO> jdbcRegistryDataOptional = this.jdbcRegistryDataRepository.selectByKey(key);
        if (!jdbcRegistryDataOptional.isPresent()) {
            return;
        }
        this.jdbcRegistryTransactionTemplate.execute(status -> {
            this.jdbcRegistryDataRepository.deleteByKey(key);
            JdbcRegistryDataChangeEventDTO registryDataChangeEvent = JdbcRegistryDataChangeEventDTO.builder().jdbcRegistryData((JdbcRegistryDataDTO)jdbcRegistryDataOptional.get()).eventType(JdbcRegistryDataChangeEventDTO.EventType.DELETE).createTime(new Date()).build();
            this.jdbcRegistryDataChangeEventRepository.insert(registryDataChangeEvent);
            return null;
        });
    }

    private void doTriggerJdbcRegistryDataAddedListener(List<JdbcRegistryDataDTO> valuesToAdd) {
        if (CollectionUtils.isEmpty(valuesToAdd)) {
            return;
        }
        log.debug("Trigger:onJdbcRegistryDataAdded: {}", valuesToAdd);
        valuesToAdd.forEach(jdbcRegistryData -> {
            try {
                this.registryRowChangeListeners.forEach(listener -> listener.onRegistryRowAdded(jdbcRegistryData));
            }
            catch (Exception ex) {
                log.error("Trigger:onRegistryRowAdded: {} failed", jdbcRegistryData, (Object)ex);
            }
        });
    }

    private void doTriggerJdbcRegistryDataRemovedListener(List<JdbcRegistryDataDTO> valuesToRemoved) {
        if (CollectionUtils.isEmpty(valuesToRemoved)) {
            return;
        }
        log.debug("Trigger:onJdbcRegistryDataDeleted: {}", valuesToRemoved);
        valuesToRemoved.forEach(jdbcRegistryData -> {
            try {
                this.registryRowChangeListeners.forEach(listener -> listener.onRegistryRowDeleted(jdbcRegistryData));
            }
            catch (Exception ex) {
                log.error("Trigger:onRegistryRowAdded: {} failed", jdbcRegistryData, (Object)ex);
            }
        });
    }

    private void doTriggerJdbcRegistryDataUpdatedListener(List<JdbcRegistryDataDTO> valuesToUpdated) {
        if (CollectionUtils.isEmpty(valuesToUpdated)) {
            return;
        }
        log.debug("Trigger:onJdbcRegistryDataUpdated: {}", valuesToUpdated);
        valuesToUpdated.forEach(jdbcRegistryData -> {
            try {
                this.registryRowChangeListeners.forEach(listener -> listener.onRegistryRowUpdated(jdbcRegistryData));
            }
            catch (Exception ex) {
                log.error("Trigger:onRegistryRowAdded: {} failed", jdbcRegistryData, (Object)ex);
            }
        });
    }
}

