/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.extract.base.client;

import java.lang.reflect.Method;
import org.apache.dolphinscheduler.extract.base.IRpcResponse;
import org.apache.dolphinscheduler.extract.base.RpcMethod;
import org.apache.dolphinscheduler.extract.base.StandardRpcRequest;
import org.apache.dolphinscheduler.extract.base.SyncRequestDto;
import org.apache.dolphinscheduler.extract.base.client.AbstractClientMethodInvoker;
import org.apache.dolphinscheduler.extract.base.client.NettyRemotingClient;
import org.apache.dolphinscheduler.extract.base.exception.MethodInvocationException;
import org.apache.dolphinscheduler.extract.base.protocal.Transporter;
import org.apache.dolphinscheduler.extract.base.protocal.TransporterHeader;
import org.apache.dolphinscheduler.extract.base.serialize.JsonSerializer;
import org.apache.dolphinscheduler.extract.base.utils.Host;

class SyncClientMethodInvoker
extends AbstractClientMethodInvoker {
    SyncClientMethodInvoker(Host serverHost, Method localMethod, NettyRemotingClient nettyRemotingClient) {
        super(serverHost, localMethod, nettyRemotingClient);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RpcMethod sync = method.getAnnotation(RpcMethod.class);
        Transporter transporter = Transporter.of(TransporterHeader.of(this.methodIdentifier), JsonSerializer.serialize(StandardRpcRequest.of(args)));
        SyncRequestDto syncRequestDto = SyncRequestDto.builder().timeoutMillis(sync.timeout()).retryStrategy(sync.retry()).transporter(transporter).serverHost(this.serverHost).build();
        IRpcResponse iRpcResponse = this.nettyRemotingClient.sendSync(syncRequestDto);
        if (!iRpcResponse.isSuccess()) {
            throw MethodInvocationException.of(iRpcResponse.getMessage());
        }
        if (iRpcResponse.getBody() == null) {
            return null;
        }
        Class<?> responseClass = method.getReturnType();
        return JsonSerializer.deserialize(iRpcResponse.getBody(), responseClass);
    }
}

