/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import io.fabric8.kubernetes.client.dsl.LogWatch;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskCallBack;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.apache.dolphinscheduler.plugin.task.api.model.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.api.parser.TaskOutputParameterParser;
import org.apache.dolphinscheduler.plugin.task.api.shell.IShellInterceptorBuilder;
import org.apache.dolphinscheduler.plugin.task.api.utils.LogUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.ProcessUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.ShellUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommandExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCommandExecutor.class);
    protected volatile Map<String, String> taskOutputParams = new HashMap<String, String>();
    private Process process;
    protected TaskExecutionContext taskRequest;

    public AbstractCommandExecutor(TaskExecutionContext taskRequest) {
        this.taskRequest = taskRequest;
    }

    public TaskResponse run(IShellInterceptorBuilder iShellInterceptorBuilder, TaskCallBack taskCallBack) throws Exception {
        TaskResponse result = new TaskResponse();
        int taskInstanceId = this.taskRequest.getTaskInstanceId();
        iShellInterceptorBuilder = iShellInterceptorBuilder.shellDirectory(this.taskRequest.getExecutePath()).shellName(this.taskRequest.getTaskAppId());
        if (CollectionUtils.isNotEmpty(ShellUtils.ENV_SOURCE_LIST)) {
            ShellUtils.ENV_SOURCE_LIST.forEach(iShellInterceptorBuilder::appendSystemEnv);
        }
        if (StringUtils.isNotBlank((CharSequence)this.taskRequest.getEnvironmentConfig())) {
            iShellInterceptorBuilder.appendCustomEnvScript(this.taskRequest.getEnvironmentConfig());
        }
        if (this.taskRequest.getK8sTaskExecutionContext() != null) {
            iShellInterceptorBuilder.k8sConfigYaml(this.taskRequest.getK8sTaskExecutionContext().getConfigYaml());
        }
        iShellInterceptorBuilder.sudoMode(OSUtils.isSudoEnable());
        iShellInterceptorBuilder.runUser(this.taskRequest.getTenantCode());
        if (this.taskRequest.getCpuQuota() != null) {
            iShellInterceptorBuilder.cpuQuota(this.taskRequest.getCpuQuota());
        }
        if (this.taskRequest.getMemoryMax() != null) {
            iShellInterceptorBuilder.memoryQuota(this.taskRequest.getMemoryMax());
        }
        Object iShellInterceptor = iShellInterceptorBuilder.build();
        this.process = iShellInterceptor.execute();
        CompletableFuture<Void> collectProcessLogFuture = this.collectProcessLog(this.process);
        Optional<CompletableFuture<?>> collectPodLogFuture = this.collectPodLogIfNeeded();
        int processId = this.getProcessId(this.process);
        result.setProcessId(processId);
        this.taskRequest.setProcessId(processId);
        log.info("process start, process id is: {}", (Object)processId);
        long remainTime = this.getRemainTime();
        if (null != taskCallBack) {
            taskCallBack.updateTaskInstanceInfo(taskInstanceId);
        }
        boolean status = this.process.waitFor(remainTime, TimeUnit.SECONDS);
        TaskExecutionStatus kubernetesStatus = ProcessUtils.getApplicationStatus(this.taskRequest.getK8sTaskExecutionContext(), this.taskRequest.getTaskAppId());
        collectProcessLogFuture.join();
        if (collectPodLogFuture.isPresent()) {
            collectPodLogFuture.get().join();
            ProcessUtils.cancelApplication(this.taskRequest);
        }
        if (status && kubernetesStatus.isSuccess()) {
            result.setExitStatusCode(this.process.exitValue());
        } else {
            log.error("process has failure due to timeout kill, timeout value is:{}, timeoutStrategy is:{}", (Object)this.taskRequest.getTaskTimeout(), (Object)this.taskRequest.getTaskTimeoutStrategy());
            result.setExitStatusCode(-1);
        }
        int exitCode = this.process.exitValue();
        String exitLogMessage = 137 == exitCode || 143 == exitCode ? "process has killed." : "process has exited.";
        log.info("{} execute path:{}, processId:{} ,exitStatusCode:{} ,processWaitForStatus:{} ,processExitValue:{}", new Object[]{exitLogMessage, this.taskRequest.getExecutePath(), processId, result.getExitStatusCode(), status, exitCode});
        return result;
    }

    public Map<String, String> getTaskOutputParams() {
        return this.taskOutputParams;
    }

    public void cancelApplication() throws InterruptedException {
        if (this.process == null) {
            return;
        }
        boolean killed = ProcessUtils.kill(this.taskRequest);
        if (killed) {
            log.info("Process tree for task: {} is killed or already finished, pid: {}", (Object)this.taskRequest.getTaskAppId(), (Object)this.taskRequest.getProcessId());
        } else {
            log.error("Failed to kill process tree for task: {}, pid: {}", (Object)this.taskRequest.getTaskAppId(), (Object)this.taskRequest.getProcessId());
        }
        ProcessUtils.cancelApplication(this.taskRequest);
    }

    private Optional<CompletableFuture<?>> collectPodLogIfNeeded() {
        if (null == this.taskRequest.getK8sTaskExecutionContext()) {
            return Optional.empty();
        }
        ScheduledExecutorService collectPodLogExecutorService = ThreadUtils.newSingleDaemonScheduledExecutorService((String)("CollectPodLogOutput-thread-" + this.taskRequest.getTaskName()));
        CompletableFuture<Void> collectPodLogFuture = CompletableFuture.runAsync(() -> {
            ThreadUtils.sleep((long)5000L);
            try (LogWatch watcher = ProcessUtils.getPodLogWatcher(this.taskRequest.getK8sTaskExecutionContext(), this.taskRequest.getTaskAppId(), "");){
                if (watcher == null) {
                    throw new RuntimeException("The driver pod does not exist.");
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(watcher.getOutput()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        log.info("[K8S-pod-log-{}]: {}", (Object)this.taskRequest.getTaskName(), (Object)line);
                    }
                }
            }
            catch (Exception e) {
                log.error("Collect pod log error", (Throwable)e);
                throw new RuntimeException(e);
            }
        }, collectPodLogExecutorService);
        collectPodLogExecutorService.shutdown();
        return Optional.of(collectPodLogFuture);
    }

    private CompletableFuture<Void> collectProcessLog(Process process) {
        ScheduledExecutorService collectProcessLogService = ThreadUtils.newSingleDaemonScheduledExecutorService((String)("ResolveOutputLog-thread-" + this.taskRequest.getTaskName()));
        CompletableFuture<Void> collectProcessLogFuture = CompletableFuture.runAsync(() -> {
            TaskOutputParameterParser taskOutputParameterParser = new TaskOutputParameterParser();
            try (BufferedReader inReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                LogUtils.setTaskInstanceLogFullPathMDC(this.taskRequest.getLogPath());
                while ((line = inReader.readLine()) != null) {
                    log.info(" -> {}", (Object)line);
                    taskOutputParameterParser.appendParseLog(line);
                }
            }
            catch (Exception e) {
                log.error("Parse var pool error", (Throwable)e);
            }
            finally {
                LogUtils.removeTaskInstanceLogFullPathMDC();
            }
            this.taskOutputParams = taskOutputParameterParser.getTaskOutputParams();
        }, collectProcessLogService);
        collectProcessLogService.shutdown();
        return collectProcessLogFuture;
    }

    private long getRemainTime() {
        long usedTime = (System.currentTimeMillis() - this.taskRequest.getStartTime()) / 1000L;
        long remainTime = (long)this.taskRequest.getTaskTimeout() - usedTime;
        if (remainTime < 0L) {
            throw new RuntimeException("task execution time out");
        }
        return remainTime;
    }

    private int getProcessId(Process process) {
        int processId = 0;
        try {
            Field f = process.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            processId = f.getInt(process);
        }
        catch (Exception e) {
            log.error("Get task pid failed", (Throwable)e);
        }
        return processId;
    }
}

